package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.trim.TrimmedType;
import java.nio.file.Path;
import net.minecraft.class_2960;
import net.minecraft.class_8053;

public record TrimSpriteMetadata(class_8053 trim, TrimPalette palette, class_2960 baseTexture, TrimmedType trimmedType) {
	public boolean isAnimated() {
		return palette.isAnimated();
	}

	public Path toDebugPath() {
		String pattern = trim.comp_3180().comp_349().comp_1213().toString().replace(':', '/');
		String material = trim.comp_3179().comp_349().comp_3606().comp_3603().comp_3605().replace(':', '/');
		String metadata = palette.getMetadataString();
		String baseTexturePath = baseTexture.method_12836() + "/" + baseTexture.method_12832().replace(':', '/');
		baseTexturePath = baseTexturePath.substring(0, baseTexturePath.lastIndexOf('.'));
		String fileName = String.format("%s/%s/%s/%s", baseTexturePath, pattern, material, metadata);
		return Path.of(fileName);
	}
}