package com.bawnorton.trimica.mixin;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_6880;
import net.minecraft.class_8054;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

@Mixin(class_8054.class)
public abstract class TrimMaterialMixin {
	@Shadow
	@Final
	@Mutable
	public static Codec<class_6880<class_8054>> CODEC;

	static {
		CODEC = CODEC.xmap(Trimica.getDataFixer()::fixDynamicTrimMaterialSuffix, Function.identity())
				.xmap(Trimica.getRuntimeTags()::convertHolder, Trimica.getRuntimeTags()::convertHolder);
	}

	@ModifyArg(
			method = "<clinit>",
			at = @At(
					value = "INVOKE",
					target = "Lcom/mojang/serialization/codecs/RecordCodecBuilder;create(Ljava/util/function/Function;)Lcom/mojang/serialization/Codec;"
			),
			remap = false
	)
	private static Function<RecordCodecBuilder.Instance<class_8054>, ? extends App<RecordCodecBuilder.Mu<class_8054>, class_8054>> wrapCodec(Function<RecordCodecBuilder.Instance<class_8054>, ? extends App<RecordCodecBuilder.Mu<class_8054>, class_8054>> builder) {
		return instance -> instance.group(
				RecordCodecBuilder.mapCodec(builder).forGetter(Function.identity()),
				MaterialAdditions.CODEC.lenientOptionalFieldOf("trimica$additions").forGetter(material -> Optional.ofNullable(Trimica.getMaterialRegistry().getIntrinsicAdditions(material)))
		).apply(
				instance, (trimMaterial, additions) -> {
					Trimica.getMaterialRegistry().setIntrinsicAdditions(trimMaterial, additions.orElse(null));
					return trimMaterial;
				}
		);
	}

	@ModifyExpressionValue(
			method = "<clinit>",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/network/codec/StreamCodec;composite(Lnet/minecraft/network/codec/StreamCodec;Ljava/util/function/Function;Lnet/minecraft/network/codec/StreamCodec;Ljava/util/function/Function;Ljava/util/function/BiFunction;)Lnet/minecraft/network/codec/StreamCodec;"
			)
	)
	private static class_9139<class_9129, class_8054> wrapStreamCodec(class_9139<class_9129, class_8054> original) {
		return class_9139.method_56435(
				original, Function.identity(),
				MaterialAdditions.STREAM_CODEC, (trimMaterial) -> Trimica.getMaterialRegistry().getIntrinsicAdditions(trimMaterial),
				(trimMaterial, additions) -> {
					Trimica.getMaterialRegistry().setIntrinsicAdditions(trimMaterial, additions);
					return trimMaterial;
				}
		);
	}
}
