package com.bawnorton.trimica.mixin.crafting;

import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3544;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_8047;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1706.class)
public abstract class AnvilMenuMixin extends class_4861 {
	@Shadow
	private int repairItemCountCost;

	@Shadow
	private @Nullable String itemName;

	@Shadow
	@Final
	private class_3915 cost;

	public AnvilMenuMixin(@Nullable class_3917<?> menuType, int containerId, class_1661 inventory, class_3914 access, class_8047 slotDefinition) {
		super(menuType, containerId, inventory, access, slotDefinition);
	}

	@Inject(
			method = "createResult",
			at = @At("HEAD"),
			cancellable = true
	)
	private void addTrimRemovalResult(CallbackInfo ci) {
		class_1799 armour = field_22480.method_5438(0);
		class_1799 tool = field_22480.method_5438(1);

		class_1799 mutableArmour = armour.method_7972();
		if (tool.method_31574(class_1802.field_8145)) {
			AdditionalTrims.correctTrimComponents(mutableArmour);
			int remainder = AdditionalTrims.removeTrims(mutableArmour, tool.method_7947());
			trimica$applyTool(ci, armour, tool, mutableArmour, remainder);
		} else if (tool.method_31574(class_1802.field_8153) && MaterialAdditions.enableMaterialAdditions) {
			int remainder = MaterialAdditions.removeMaterials(mutableArmour, tool.method_7947());
			trimica$applyTool(ci, armour, tool, mutableArmour, remainder);
		}
	}

	@Unique
	private void trimica$applyTool(CallbackInfo ci, class_1799 armour, class_1799 tool, class_1799 mutableArmour, int remainder) {
		if (!class_1799.method_7973(mutableArmour, armour)) {
			field_22479.method_5447(0, mutableArmour);
			repairItemCountCost = tool.method_7947() - remainder;

			int cost = repairItemCountCost;
			if (itemName != null && !class_3544.method_57181(itemName)) {
				if (!itemName.equals(armour.method_7964().getString())) {
					cost += 1;
					mutableArmour.method_57379(class_9334.field_49631, class_2561.method_43470(this.itemName));
				}
			} else if (armour.method_57826(class_9334.field_49631)) {
				cost += 1;
				mutableArmour.method_57381(class_9334.field_49631);
			}
			this.cost.method_17404(cost);

			method_7623();
			ci.cancel();
		}
	}
}
