package com.bawnorton.trimica.client.palette;

import com.bawnorton.trimica.TrimicaToggles;
import com.bawnorton.trimica.api.PaletteInterceptor;
import com.bawnorton.trimica.item.TrimicaItems;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import net.minecraft.class_1802;
import net.minecraft.class_7923;

public class DefaultPaletteInterceptor implements PaletteInterceptor {
	@Override
	public TrimPalette interceptMaterialAdditions(TrimPalette palette, MaterialAdditions additions) {
		if(palette == TrimPalette.MISSING || palette == TrimPalette.DISABLED || palette == TrimPalette.DEFAULT) {
			return palette;
		}

		if (TrimicaToggles.enableItems && TrimicaToggles.enableAnimator) {
			if (additions.matches(class_7923.field_41178.method_10221(TrimicaItems.ANIMATOR))) {
				palette = palette.asAnimated();
			}
		}
		if (additions.matches(class_7923.field_41178.method_10221(class_1802.field_28410))) {
			palette.setEmissive(true);
		}
		return palette;
	}
}
