package com.bawnorton.trimica.client.palette;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.api.impl.TrimicaApiImpl;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_10394;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_8054;
import net.minecraft.class_9473;

public final class TrimPalettes {
	private final ConcurrentMap<class_2960, TrimPalette> cache = new ConcurrentHashMap<>();
	private final TrimPaletteGenerator generator = new TrimPaletteGenerator();

	public TrimPalette getOrGeneratePalette(class_8054 material, @Nullable class_5321<class_10394> assetKey, @Nullable class_9473 componentGetter) {
		class_2960 key = Trimica.rl(Trimica.getMaterialRegistry().getSuffix(material, assetKey));
		MaterialAdditions additions;
		if (componentGetter == null || !MaterialAdditions.enableMaterialAdditions) {
			additions = MaterialAdditions.NONE;
		} else {
			additions = Trimica.getMaterialRegistry().getIntrinsicAdditions(material)
					.and(componentGetter.method_58694(MaterialAdditions.TYPE));
			key = additions.apply(key);
		}
		return cache.computeIfAbsent(key, k -> {
			TrimPalette palette = generator.generatePalette(material, assetKey);
			palette = TrimicaApiImpl.INSTANCE.applyPaletteInterceptorsForMaterialAdditions(palette, additions);
			return TrimicaApiImpl.INSTANCE.applyPaletteInterceptorsForGeneration(palette, material);
		});
	}

	public @Nullable TrimPalette getPalette(class_8054 material, class_5321<class_10394> assetKey, @Nullable class_9473 componentGetter) {
		String suffix = Trimica.getMaterialRegistry().getSuffix(material, assetKey);
		class_2960 key = Trimica.rl(suffix);
		if (componentGetter != null && MaterialAdditions.enableMaterialAdditions) {
			MaterialAdditions addition = componentGetter.method_58695(MaterialAdditions.TYPE, MaterialAdditions.NONE);
			key = addition.apply(key);
		}
		return cache.get(key);
	}

	public void clear() {
		cache.clear();
		generator.clear();
	}
}