package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.client.mixin.accessor.*;
import com.bawnorton.trimica.client.mixin.accessor.AtlasManager.PendingStitchResultsAccessor;
import com.bawnorton.trimica.client.mixin.accessor.TextureAtlasSprite.TickerAccessor;
import com.bawnorton.trimica.client.palette.TrimPalette;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_11697;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import net.minecraft.class_8056;
import net.minecraft.class_9473;
import net.minecraft.client.renderer.texture.*;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public final class RuntimeTrimAtlas extends class_1059 {
	private final AbstractTrimSpriteFactory spriteFactory;
	private final RuntimeTrimAtlases.TrimFactory trimFactory;
	private final class_1921 renderType;
	private final List<class_7764> dynamicSprites = new ArrayList<>();
	private final Map<class_2960, TrimPalette> palettes = new HashMap<>();
	private final Consumer<RuntimeTrimAtlas> onModified;
	//? if >=1.21.10
	private final class_11697.class_7772 atlasEntry;

	public RuntimeTrimAtlas(class_2960 atlasLocation, AbstractTrimSpriteFactory spriteFactory, RuntimeTrimAtlases.TrimFactory trimFactory, Consumer<RuntimeTrimAtlas> onModified) {
		super(atlasLocation);
		this.spriteFactory = spriteFactory;
		this.trimFactory = trimFactory;
		this.renderType = class_1921.method_25448(atlasLocation);
		dynamicSprites.add(createMissing());
		this.onModified = onModified;
		//? if >=1.21.10 {
		class_11697.class_11698 atlasConfig = new class_11697.class_11698(atlasLocation, Trimica.rl("generated"), false);
		this.atlasEntry = new class_11697.class_7772(this, atlasConfig);
		//?}
	}

	private class_7764 createMissing() {
		class_2960 missingLocation = class_1047.method_4539();
		return spriteFactory.create(missingLocation, null, null).spriteContents();
	}

	@Override
	public @NotNull class_1058 method_4608(@NotNull class_2960 texture) {
		throw new UnsupportedOperationException("Use getSprite(DataComponentGetter, TrimMaterial, ResourceLocation) instead");
	}

	public @NotNull DynamicTrimTextureAtlasSprite getSprite(class_9473 componentGetter, class_8056 pattern, class_2960 texture) {
		Map<class_2960, class_1058> texturesByName = asAccessor().trimica$texturesByName();
		class_1058 sprite = texturesByName.get(texture);
		if (sprite == null) {
			TrimTextureAtlasSprite trimTextureAtlasSprite = createSprite(componentGetter, pattern, texture);
			sprite = trimTextureAtlasSprite.sprite();
			TrimPalette palette = trimTextureAtlasSprite.palette();
			palettes.put(texture, palette);
		}
		return new DynamicTrimTextureAtlasSprite(sprite, renderType, palettes.get(texture));
	}

	private TrimTextureAtlasSprite createSprite(class_9473 componentGetter, class_8056 pattern, class_2960 texture) {
		TrimSpriteContents sprite = spriteFactory.create(texture, trimFactory.create(pattern), componentGetter);
		dynamicSprites.add(sprite.spriteContents());
		stitchAndUpload();
		onModified.accept(this);
		class_310 client = class_310.method_1551();
		client.method_1531().method_4616(method_24106(), this);
		return new TrimTextureAtlasSprite(asAccessor().trimica$texturesByName().get(texture), sprite.palette());
	}

	//? if >=1.21.10 {
	private void stitchAndUpload() {
		List<class_11697.class_11699> pendingStitches = new ArrayList<>();
		Map<class_2960, CompletableFuture<class_7766.class_7767>> stitchFutureById = new HashMap<>();
		List<CompletableFuture<?>> allReadyToUpload = new ArrayList<>();
		CompletableFuture<class_7766.class_7767> preparations = new CompletableFuture<>();
		stitchFutureById.put(method_24106(), preparations);
		pendingStitches.add(new class_11697.class_11699(atlasEntry, preparations));
		allReadyToUpload.add(preparations.thenCompose(class_7766.class_7767::comp_1045));
		PendingStitchResultsAccessor pendingStitchResults = (PendingStitchResultsAccessor) PendingStitchResultsAccessor.trimica$init(
				pendingStitches,
				stitchFutureById,
				CompletableFuture.allOf(allReadyToUpload.toArray(new CompletableFuture[0]))
		);
		SpriteLoaderAccessor loader = (SpriteLoaderAccessor) class_7766.method_45837(this);
		pendingStitchResults.trimica$pendingStitches().forEach(stitch -> {
			class_7766.class_7767 stitched = loader.trimica$stitch(dynamicSprites, 0, class_156.method_18349());
			if(stitched != null) {
				stitch.comp_4559().complete(stitched);
			} else {
				stitch.comp_4559().completeExceptionally(new RuntimeException("Failed to stitch dynamic trim atlas"));
			}
		});
		pendingStitchResults.trimica$allReadyToUpload()
				.thenApply(o -> ((class_11697.class_11700) pendingStitchResults).method_73037())
				.join();
	}
	//?} else {
	/*private void stitchAndUpload() {
		SpriteLoader loader = SpriteLoader.create(this);
		SpriteLoader.Preparations preparations = loader.stitch(dynamicSprites, 0, Util.backgroundExecutor());
		AtlasSet.StitchResult result = new AtlasSet.StitchResult(this, preparations);
		result.upload();
	}
	*///?}

	/**
	 * @implNote Doesn't close or clear dynamic sprites, as {@link #stitchAndUpload} calls {@code clearTextureData} - we
	 * don't want to lose our previously computed dynamic sprites every time a new one is added
	 */
	public void method_4601() {
		TextureAtlasAccessor accessor = asAccessor();
		accessor.trimica$sprites(List.of());
		accessor.trimica$animatedTextures(List.of());
		accessor.trimica$texturesByName(Map.of());
		accessor.trimica$missingSprite(null);
	}

	/**
	 * Ensure's all animated textures are in-sync
	 */
	@SuppressWarnings("resource")
	public void resetFrames() {
		List<class_1058.class_7770> tickers = asAccessor().trimica$animatedTextures();
		for (class_1058.class_7770 ticker : tickers) {
			if (ticker instanceof TickerAccessor accessor && accessor.trimica$ticker() instanceof com.bawnorton.trimica.client.mixin.accessor.SpriteContents.TickerAccessor spriteTicker) {
				spriteTicker.trimica$frame(0);
			}
		}
	}

	private TextureAtlasAccessor asAccessor() {
		return (TextureAtlasAccessor) (Object) this;
	}

	public void clear() {
		spriteFactory.clear();
		dynamicSprites.clear();
		dynamicSprites.add(createMissing());
		method_4601();
	}

	private record TrimTextureAtlasSprite(class_1058 sprite, TrimPalette palette) {
	}
}