package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.api.impl.TrimicaApiImpl;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.trim.TrimmedType;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10394;
import net.minecraft.class_10539;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_9334;
import net.minecraft.class_9473;

public class TrimArmourSpriteFactory extends AbstractTrimSpriteFactory {
	private final class_10186.class_10190 layerType;
	public static final ThreadLocal<class_1799> ITEM_WITH_TRIM_CAPTURE = ThreadLocal.withInitial(() -> null);

	public TrimArmourSpriteFactory(class_10186.class_10190 layerType) {
		super(64, 32);
		this.layerType = layerType;
	}

	@Nullable
	protected TrimSpriteMetadata getSpriteMetadata(class_8053 trim, class_9473 componentGetter, class_2960 texture) {
		if (!(componentGetter instanceof class_1799 stack)) return null;

		TrimmedType trimmedType = TrimmedType.of(stack);
		class_8054 material = trim.comp_3179().comp_349();
		class_5321<class_10394> assetResourceKey = Optional.ofNullable(stack.method_58694(class_9334.field_54196))
				.flatMap(class_10192::comp_3176)
				.orElse(null);
		TrimPalette palette = TrimicaClient.getPalettes().getOrGeneratePalette(material, assetResourceKey, componentGetter);
		class_2960 basePatternTexture = extractBaseTexture(texture, trim.comp_3180().comp_349().comp_1213());
		basePatternTexture = TrimicaApiImpl.INSTANCE.applyBaseTextureInterceptorsForArmour(basePatternTexture, stack, trim);
		return new TrimSpriteMetadata(trim, palette, basePatternTexture, trimmedType);
	}

	protected class_1011 createImageFromMetadata(TrimSpriteMetadata metadata) {
		class_310 minecraft = class_310.method_1551();
		class_10539 contents = textureCache.computeIfAbsent(metadata.baseTexture(), k -> {
			try {
				return class_10539.method_65871(minecraft.method_1478(), metadata.baseTexture());
			} catch (IOException e) {
				Trimica.LOGGER.warn("Expected to find \"{}\" but the texture does of exist, trim overlay will not be added to model", metadata.baseTexture());
				return new class_10539(empty(), null);
			}
		});
		return createColouredImage(metadata, contents);
	}

	private class_2960 extractBaseTexture(class_2960 texture, class_2960 assetId) {
		return texture.method_45136("textures/%s/%s.png".formatted(layerType.method_67293(), assetId.method_12832()));
	}
}