package com.bawnorton.trimica.command;

import com.bawnorton.configurable.api.ConfigurableApi;
import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.client.texture.TrimItemSpriteFactory;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.ComponentUtil;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10192;
import net.minecraft.class_10711;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2379;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9334;

public class TrimicaCommandManager {
	public static void init(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext) {
		dispatcher.register(class_2170.method_9247("trimica")
				.then(class_2170.method_9247("debug")
						.requires(source -> source.method_9259(4))
						.then(class_2170.method_9247("summon")
								.then(class_2170.method_9247("all")
										.executes(context -> {
											summonArmourStands(context, true);
											return 1;
										}))
								.executes(context -> summonArmourStands(context, false))
						)
				)
				.then(class_2170.method_9247("toggle")
						.requires(source -> source.method_9259(2))
						.then(class_2170.method_9244("configEntry", StringArgumentType.word())
								.suggests((context, builder) -> class_2172.method_9265(
										List.of(
												"trimEverything",
												"materialAdditions",
												"perPatternItemTextures",
												"additionalTrims"
										),
										builder
								))
								.then(class_2170.method_9244("value", StringArgumentType.word())
										.suggests((context, builder) -> class_2172.method_9265(
												List.of("true", "false"),
												builder
										))
										.executes(TrimicaCommandManager::setConfigValue)
								)
						)
				)
		);
	}

	private static int summonArmourStands(CommandContext<class_2168> context, boolean allMaterials) {
		class_2168 source = context.getSource();
		class_5455 registryAccess = source.method_30497();
		class_7225.class_7226<class_8056> patternLookup = registryAccess.method_30530(class_7924.field_42082);
		class_3218 level = source.method_9225();
		class_2338.class_2339 pos = class_2338.method_49638(source.method_9222()).method_25503();

		List<? extends class_6880<class_8054>> materials;
		if (allMaterials) {
			materials = registryAccess.method_30530(class_7924.field_41197).method_42017().map(itemRef -> {
				class_1792 item = itemRef.comp_349();
				class_10711 trimMaterialProvider = item.method_7854().method_58694(class_9334.field_56397);
				if (trimMaterialProvider == null) return null;

				return trimMaterialProvider.comp_3599().method_60739(registryAccess).orElse(null);
			}).filter(Objects::nonNull).toList();
		} else {
			materials = registryAccess.method_30530(class_7924.field_42083).method_42017().toList();
		}

		source.method_45068(class_2561.method_43470("Summoning %s armour stands at %s".formatted(
				patternLookup.method_46754().count() * materials.size(), pos.method_23854()
		)));
		var ref = new Object() {
			boolean flag = false;
		};
		patternLookup.method_42017()
				.forEach(patternRef -> {
					materials.forEach(materialRef -> {
						List<class_1799> toEquip = ComponentUtil.getTrimmedEquipment(new class_8053(materialRef, patternRef));
						class_1531 stand = class_1299.field_6131.method_5888(
								level, armourStand -> {
									armourStand.method_5875(true);
									armourStand.method_6907(true);
									armourStand.method_6913(true);
									armourStand.method_60608(0, 0);
									armourStand.method_6910(new class_2379(-70, 80, -20));
									toEquip.forEach(stack -> {
										class_10192 equippable = stack.method_58694(class_9334.field_54196);
										assert equippable != null;

										armourStand.method_5673(equippable.comp_3174(), stack);
									});
								}, pos, class_3730.field_16471, false, false
						);
						if (stand != null) {
							level.method_8649(stand);
						}
						pos.method_10104(class_2350.field_11034, 2);
					});
					pos.method_10104(class_2350.field_11039, 2 * materials.size());
					pos.method_10098(class_2350.field_11036);
					//noinspection AssignmentUsedAsCondition - Deliberate
					if (ref.flag = !ref.flag) {
						pos.method_10098(class_2350.field_11039);
					} else {
						pos.method_10098(class_2350.field_11034);
					}
					pos.method_10098(class_2350.field_11043);
				});
		return 1;
	}

	private static int setConfigValue(CommandContext<class_2168> context) {
		class_2168 source = context.getSource();
		String configEntry = StringArgumentType.getString(context, "configEntry");
		String value = StringArgumentType.getString(context, "value");

		boolean newValue;
		try {
			newValue = Boolean.parseBoolean(value);
		} catch (Exception e) {
			source.method_9213(class_2561.method_43470("Invalid value: %s. Must be 'true' or 'false'.".formatted(value)));
			return 0;
		}

		switch (configEntry) {
			case "trimEverything" -> {
				TrimMaterialRuntimeRegistry.enableTrimEverything = newValue;
				ConfigurableApi.saveChanges(source.method_9225(), true);
			}
			case "materialAdditions" -> {
				MaterialAdditions.enableMaterialAdditions = newValue;
				ConfigurableApi.saveChanges(source.method_9225(), true);
			}
			case "perPatternItemTextures" -> {
				Trimica.enablePerPatternItemTextures = newValue;
				ConfigurableApi.saveChanges(source.method_9225(), true);
			}
			case "additionalTrims" -> {
				AdditionalTrims.enableAdditionalTrims = newValue;
				ConfigurableApi.saveChanges(source.method_9225(), true);
			}
			default -> {
				source.method_9213(class_2561.method_43470("Unknown config entry: %s".formatted(configEntry)));
				return 0;
			}
		}

		source.method_9226(() -> class_2561.method_43470("Set %s to %s".formatted(configEntry, value)), true);
		return 1;
	}
}
