package com.bawnorton.trimica.item.crafting;

import com.bawnorton.trimica.api.impl.TrimicaApiImpl;
import com.bawnorton.trimica.data.TrimicaDataGen;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10358;
import net.minecraft.class_10363;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8053;
import net.minecraft.class_8059;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import net.minecraft.class_9697;
import net.minecraft.class_9887;
import net.minecraft.world.item.crafting.*;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class MaterialAdditionRecipe implements class_8059 {
	public static Serializer SERIALIZER;

	private final class_1856 base;
	private final class_1856 addition;
	private class_9887 placementInfo;

	public MaterialAdditionRecipe(class_1856 base, class_1856 addition) {
		if(TrimicaDataGen.duringDataGen) {
			this.base = base;
		} else {
			this.base = TrimicaApiImpl.INSTANCE.applyCraftingRecipeInterceptorsForBase(base);
		}
		this.addition = addition;
	}

	@Override
	public @NotNull class_1799 assemble(@NotNull class_9697 recipeInput, @NotNull class_7225.class_7874 provider) {
		return applyMaterialAddition(recipeInput.comp_2678(), recipeInput.comp_2679());
	}

	public static @NotNull class_1799 applyMaterialAddition(class_1799 base, class_1799 addition) {
		if (!MaterialAdditions.enableMaterialAdditions) return class_1799.field_8037;

		class_8053 existing = base.method_58694(class_9334.field_49607);
		if (existing == null) return class_1799.field_8037;

		MaterialAdditions materialAdditions = base.method_58695(MaterialAdditions.TYPE, MaterialAdditions.NONE);
		class_2960 additionKey = class_7923.field_41178.method_10221(addition.method_7909());
		MaterialAdditions newMaterialAdditon = materialAdditions.and(additionKey);
		if (materialAdditions.equals(newMaterialAdditon)) return class_1799.field_8037;

		class_1799 result = base.method_46651(1);
		result.method_57379(MaterialAdditions.TYPE, newMaterialAdditon);
		return result;
	}

	@Override
	public @NotNull class_1865<? extends class_8059> method_8119() {
		return SERIALIZER;
	}

	@Override
	public @NotNull class_9887 method_61671() {
		if (placementInfo == null) {
			placementInfo = class_9887.method_61683(List.of(Optional.empty(), Optional.of(this.base), Optional.of(this.addition)));
		}
		return placementInfo;
	}

	@Override
	public @NotNull Optional<class_1856> method_64722() {
		return Optional.empty();
	}

	@Override
	public @NotNull class_1856 method_64723() {
		return base;
	}

	@Override
	public @NotNull Optional<class_1856> method_64724() {
		return Optional.of(addition);
	}

	@Override
	public @NotNull List<class_10295> method_64664() {
		class_10302 baseSlot = base.method_64673();
		class_10302 additionSlot = addition.method_64673();
		return List.of(
				new Display(
						baseSlot,
						additionSlot,
						new DemoSlotDisplay(baseSlot, additionSlot),
						new class_10302.class_10306(class_1802.field_16308)
				)
		);
	}

	private class_1856 getBase() {
		return base;
	}

	private class_1856 getAddition() {
		return addition;
	}

	public static class Serializer implements class_1865<MaterialAdditionRecipe> {
		private static final MapCodec<MaterialAdditionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
				class_1856.field_46095.fieldOf("base").forGetter(MaterialAdditionRecipe::getBase),
				class_1856.field_46095.fieldOf("addition").forGetter(MaterialAdditionRecipe::getAddition)
		).apply(instance, MaterialAdditionRecipe::new));

		public static final class_9139<class_9129, MaterialAdditionRecipe> STREAM_CODEC = class_9139.method_56435(
				class_1856.field_48355,
				MaterialAdditionRecipe::getBase,
				class_1856.field_48355,
				MaterialAdditionRecipe::getAddition,
				MaterialAdditionRecipe::new
		);

		@Override
		public @NotNull MapCodec<MaterialAdditionRecipe> method_53736() {
			return CODEC;
		}

		@Override
		public @NotNull class_9139<class_9129, MaterialAdditionRecipe> method_56104() {
			return STREAM_CODEC;
		}
	}

	public record Display(class_10302 base, class_10302 addition, class_10302 result,
	                      class_10302 craftingStation) implements class_10295 {
		public static final MapCodec<Display> MAP_CODEC = RecordCodecBuilder.mapCodec(
				instance -> instance.group(
								class_10302.field_54671.fieldOf("base").forGetter(Display::base),
								class_10302.field_54671.fieldOf("addition").forGetter(Display::addition),
								class_10302.field_54671.fieldOf("result").forGetter(Display::comp_3258),
								class_10302.field_54671.fieldOf("crafting_station").forGetter(Display::comp_3259)
						)
						.apply(instance, Display::new)
		);
		public static final class_9139<class_9129, Display> field_54662 = class_9139.method_56905(
				class_10302.field_54672,
				Display::base,
				class_10302.field_54672,
				Display::addition,
				class_10302.field_54672,
				Display::comp_3258,
				class_10302.field_54672,
				Display::comp_3259,
				Display::new
		);
		public static final class_10295.class_10296<Display> TYPE = new class_10295.class_10296<>(MAP_CODEC, field_54662);

		@Override
		public @NotNull class_10296<? extends class_10295> method_64726() {
			return TYPE;
		}
	}

	public record DemoSlotDisplay(class_10302 base, class_10302 material) implements class_10302 {
		public static final MapCodec<DemoSlotDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(
				instance -> instance.group(
								class_10302.field_54671.fieldOf("base").forGetter(DemoSlotDisplay::base),
								class_10302.field_54671.fieldOf("material").forGetter(DemoSlotDisplay::material)
						)
						.apply(instance, DemoSlotDisplay::new)
		);
		public static final class_9139<class_9129, DemoSlotDisplay> field_54672 = class_9139.method_56435(
				class_10302.field_54672,
				DemoSlotDisplay::base,
				class_10302.field_54672,
				DemoSlotDisplay::material,
				DemoSlotDisplay::new
		);
		public static final class_10312<DemoSlotDisplay> TYPE = new class_10302.class_10312<>(MAP_CODEC, field_54672);

		@Override
		public <T> @NotNull Stream<T> method_64739(@NotNull class_10352 contextMap, @NotNull class_10358<T> displayContentsFactory) {
			if (!(displayContentsFactory instanceof class_10358.class_10360<T> forStacks)) return Stream.empty();

			class_7225.class_7874 provider = contextMap.method_64968(class_10363.field_54906);
			if (provider == null) return Stream.empty();

			class_5819 randomSource = class_5819.method_43049(System.identityHashCode(this));
			List<class_1799> list = this.base.method_64738(contextMap);
			if (list.isEmpty()) return Stream.empty();

			List<class_1799> list2 = this.material.method_64738(contextMap);
			if (list2.isEmpty()) return Stream.empty();

			return Stream.generate(() -> {
				class_1799 itemStack = class_156.method_32309(list, randomSource);
				class_1799 itemStack2 = class_156.method_32309(list2, randomSource);
				return MaterialAdditionRecipe.applyMaterialAddition(itemStack, itemStack2);
			}).limit(256L).filter(itemStack -> !itemStack.method_7960()).limit(16L).map(forStacks::method_64999);
		}

		@Override
		public @NotNull class_10312<? extends class_10302> method_64736() {
			return TYPE;
		}
	}
}