package com.bawnorton.trimica.mixin.registry.tag;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.TrimicaToggles;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import java.util.List;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_3503;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8054;

@Mixin(class_3503.class)
abstract class TagLoaderMixin {
	@Unique
	private static final ThreadLocal<class_2385<class_8054>> trimica$trimRegistry = new ThreadLocal<>();

	@SuppressWarnings("unchecked")
	@WrapOperation(
			method = "loadTagsForRegistry",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/core/WritableRegistry;key()Lnet/minecraft/resources/ResourceKey;"
			)
	)
	private static <T> class_5321<T> captureTrimRegistry(class_2385<T> instance, Operation<class_5321<T>> original) {
		class_5321<T> key = original.call(instance);
		if(key.equals(class_7924.field_42083)) {
			trimica$trimRegistry.set((class_2385<class_8054>) instance);
		} else {
			trimica$trimRegistry.remove();
		}
		return key;
	}

	@WrapOperation(
			method = "tryBuildTag",
			at = @At(
					value = "INVOKE",
					target = "Ljava/util/List;add(Ljava/lang/Object;)Z",
					remap = false
			)
	)
	private <E, T> boolean performRuntimeTagManipulation(List<E> instance, E e, Operation<Boolean> original, @Local SequencedSet<T> set) {
		class_3503.class_5145 entryWithSource = (class_3503.class_5145) e;
		class_3497 entry = entryWithSource.comp_324();
		return trimica$ignoreLiteralReferencesToDisabledItems(entry) && original.call(instance, e);
	}

	@SuppressWarnings("unchecked")
	@WrapOperation(
			method = "tryBuildTag",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/tags/TagEntry;build(Lnet/minecraft/tags/TagEntry$Lookup;Ljava/util/function/Consumer;)Z"
			)
	)
	private <T> boolean forwardTrimicaMaterialTagReferences(class_3497 instance, class_3497.class_7474<T> lookup, Consumer<T> consumer, Operation<Boolean> original) {
		boolean didSucceed = original.call(instance, lookup, consumer);
		if(didSucceed) return true;

		if(trimica$trimRegistry.get() != null) {
			return trimica$tryCreateRuntimeTag(instance, trimica$trimRegistry.get(), (Consumer<class_6880.class_6883<class_8054>>) consumer);
		}
		return false;
	}

	@Unique
	private static boolean trimica$tryCreateRuntimeTag(class_3497 entry, class_2385<class_8054> registry, Consumer<class_6880.class_6883<class_8054>> consumer) {
		String entryId = entry.toString();
		int trimicaGeneratedIndex = entryId.indexOf("trimica:generated/");
		if (trimicaGeneratedIndex == -1) return false;

		String materialName = entryId.substring(trimicaGeneratedIndex + "trimica:generated/".length());
		int slashIndex = materialName.indexOf('/');
		if (slashIndex == -1) return false;

		String materialNamespace = materialName.substring(0, slashIndex);
		String materialPath = materialName.substring(slashIndex + 1);
		if(materialPath.endsWith("?")) {
			materialPath = materialPath.substring(0, materialPath.length() - 1);
		}
		class_2960 materialLocation = class_2960.method_43902(materialNamespace, materialPath);
		if (materialLocation == null) return false;

		Optional<class_6880.class_6883<class_1792>> item = class_7923.field_41178.method_10223(materialLocation);
		if (item.isEmpty()) {
			Trimica.LOGGER.warn("Could not find item \"{}\" to create trim material tag for", materialLocation);
			return false;
		}

		class_6880.class_6883<class_8054> material = Trimica.getRuntimeTags().createMaterialTagForItem(item.orElseThrow(), registry);
		if (material == null) return false;

		consumer.accept(material);
		return true;
	}

	@Unique
	private static boolean trimica$ignoreLiteralReferencesToDisabledItems(class_3497 entry) {
		String entryId = entry.toString();
		if (!TrimicaToggles.enableRainbowifier || !TrimicaToggles.enableItems) {
			if (entryId.equals("trimica:rainbowifier")) return false;
		}
		if (!TrimicaToggles.enableAnimator || !TrimicaToggles.enableItems) {
			if (entryId.equals("trimica:animator")) return false;
		}
		if (!TrimicaToggles.enableItems) {
			return !entryId.equals("trimica:fake_addition");
		}
		if (!TrimMaterialRuntimeRegistry.enableTrimEverything) {
			return !entryId.startsWith("#trimica:generated/");
		}
		return true;
	}
}