/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.palette;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.api.client.impl.TrimicaClientApiImpl;
import com.bawnorton.trimica.api.impl.TrimicaApiImpl;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.palette.TrimPaletteGenerator;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_10394;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_8054;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public final class TrimPalettes {
    private final ConcurrentMap<class_2960, TrimPalette> cache = new ConcurrentHashMap<class_2960, TrimPalette>();
    private final TrimPaletteGenerator generator = new TrimPaletteGenerator();

    public TrimPalette getOrGeneratePalette(class_8054 material, @Nullable class_5321<class_10394> assetKey, @Nullable class_9473 componentGetter) {
        MaterialAdditions additions;
        class_2960 key = Trimica.rl(Trimica.getMaterialRegistry().getSuffix(material, assetKey));
        if (componentGetter == null || !MaterialAdditions.enableMaterialAdditions) {
            additions = MaterialAdditions.NONE;
        } else {
            additions = Trimica.getMaterialRegistry().getIntrinsicAdditions(material).and((MaterialAdditions)componentGetter.method_58694(MaterialAdditions.TYPE));
            key = additions.apply(key);
        }
        return this.cache.computeIfAbsent(key, k -> {
            TrimPalette palette = this.generator.generatePalette(material, assetKey);
            palette = TrimicaApiImpl.INSTANCE.applyPaletteInterceptorsForMaterialAdditions(palette, additions);
            palette = TrimicaApiImpl.INSTANCE.applyPaletteInterceptorsForGeneration(palette, material);
            return TrimicaClientApiImpl.INSTANCE.applyPaletteInterceptorsForGeneration(palette, material, additions);
        });
    }

    @Nullable
    public TrimPalette getPalette(class_8054 material, class_5321<class_10394> assetKey, @Nullable class_9473 componentGetter) {
        String suffix = Trimica.getMaterialRegistry().getSuffix(material, assetKey);
        class_2960 key = Trimica.rl(suffix);
        if (componentGetter != null && MaterialAdditions.enableMaterialAdditions) {
            MaterialAdditions addition = (MaterialAdditions)componentGetter.method_58695(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
            key = addition.apply(key);
        }
        return (TrimPalette)this.cache.get(key);
    }

    public void clear() {
        this.cache.clear();
        this.generator.clear();
    }
}

