/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.data.tags;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.mixin.accessor.HolderSet$NamedAccessor;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import com.mojang.serialization.Lifecycle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_10711;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_9248;
import net.minecraft.class_9334;

public final class TrimicaRuntimeTags {
    private final Set<UnboundTag> unboundTags = new HashSet<UnboundTag>();
    private final Map<String, class_6880.class_6883<class_8054>> references = new HashMap<String, class_6880.class_6883<class_8054>>();

    public KeyHolder createMaterialKeyHolderForItem(class_6880.class_6883<class_1792> item) {
        class_2960 id = item.method_40237().method_29177();
        class_2960 generatedId = Trimica.rl("generated/%s/%s".formatted(id.method_12836(), id.method_12832()));
        class_5321 resourceKey = class_5321.method_29179((class_5321)class_7924.field_42083, (class_2960)generatedId);
        return new KeyHolder((class_5321<class_8054>)resourceKey, (class_6862<class_8054>)class_6862.method_40092((class_5321)class_7924.field_42083, (class_2960)generatedId));
    }

    public class_6880.class_6883<class_8054> createMaterialTagForItem(class_6880.class_6883<class_1792> itemRef, class_2385<class_8054> registry) {
        class_1792 item = (class_1792)itemRef.comp_349();
        class_1799 stack = item.method_7854();
        class_10711 materialProvider = (class_10711)stack.method_58694(class_9334.field_56397);
        if (materialProvider == null) {
            if (TrimMaterialRuntimeRegistry.enableTrimEverything) {
                Trimica.LOGGER.warn("Item \"{}\" does not provide a trim material, cannot create runtime tag for it", itemRef);
            }
            return null;
        }
        class_6880 materialHolder = (class_6880)materialProvider.comp_3599().comp_3636().map(Function.identity(), key -> {
            class_6880.class_6883 ref = registry.method_46746(key).orElse(null);
            if (ref == null) {
                Trimica.LOGGER.warn("Item \"{}\" tried to provide a trim material which does not exist, cannot create runtime tag for it", (Object)itemRef);
                return null;
            }
            return ref;
        });
        if (materialHolder == null) {
            return null;
        }
        class_8054 material = (class_8054)materialHolder.method_40229().map(arg_0 -> registry.method_29107(arg_0), Function.identity());
        if (material == null) {
            Trimica.LOGGER.warn("Item \"{}\"'s trim material doesn't exist, cannot create runtime tag for it", itemRef);
            return null;
        }
        KeyHolder keyHolder = this.createMaterialKeyHolderForItem(itemRef);
        class_9248 registrationInfo = new class_9248(Optional.empty(), Lifecycle.stable());
        class_5321<class_8054> resourceKey = keyHolder.resourceKey();
        class_6880.class_6883 reference = registry.method_29113((Object)material).flatMap(arg_0 -> registry.method_46746(arg_0)).orElseGet(() -> registry.method_46746(resourceKey).orElseGet(() -> registry.method_10272(resourceKey, (Object)material, registrationInfo)));
        this.references.put(Trimica.getMaterialRegistry().getSuffix(material), (class_6880.class_6883<class_8054>)reference);
        this.unboundTags.add(new UnboundTag(keyHolder.tagKey(), (class_6880.class_6883<class_8054>)reference));
        Trimica.getMaterialRegistry().registerMaterialReference((class_6880.class_6883<class_8054>)reference);
        return reference;
    }

    public Set<class_6885.class_6888<class_8054>> bindTags(class_2378<class_8054> registry) {
        HashSet<class_6885.class_6888<class_8054>> runtimeMaterialTags = new HashSet<class_6885.class_6888<class_8054>>();
        for (UnboundTag unboundTag : this.unboundTags) {
            class_6885.class_6888<class_8054> holderSet = HolderSet$NamedAccessor.trimica$init(registry, unboundTag.key());
            HolderSet$NamedAccessor accessor = (HolderSet$NamedAccessor)holderSet;
            accessor.trimica$bind(List.of(unboundTag.material()));
            runtimeMaterialTags.add(holderSet);
        }
        return runtimeMaterialTags;
    }

    public void clear() {
        this.clearUnbound();
        this.references.clear();
    }

    public void clearUnbound() {
        this.unboundTags.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public class_6880<class_8054> convertHolder(class_6880<class_8054> holder) {
        class_8054 material;
        if (!(holder instanceof class_6880.class_6881)) return holder;
        class_6880.class_6881 class_68812 = (class_6880.class_6881)holder;
        try {
            class_8054 class_80542;
            material = class_80542 = (class_8054)class_68812.comp_349();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        String suffix = Trimica.getMaterialRegistry().getSuffix(material);
        return Objects.requireNonNullElse((class_6880)this.references.get(suffix), holder);
    }

    public record KeyHolder(class_5321<class_8054> resourceKey, class_6862<class_8054> tagKey) {
    }

    private record UnboundTag(class_6862<class_8054> key, class_6880.class_6883<class_8054> material) {
    }
}

