/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.data.tags;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.mixin.accessor.MappedRegistry$PendingTagsAnonymousAccessor;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;

public final class UnloadedTagHolder {
    private static final Map<class_2378.class_10106<?>, Map<class_6862<?>, class_6885<?>>> postponedContentsCache = new HashMap();
    private static final Map<class_6862<?>, class_6885<?>> postponedTagsContentCache = new HashMap();
    private static Map<class_5321<? extends class_2378<?>>, class_2378.class_10106<?>> unloadedTagsMap;

    public static void setUnloadedTags(List<class_2378.class_10106<?>> tags) {
        unloadedTagsMap = new HashMap();
        for (class_2378.class_10106<?> tag : tags) {
            unloadedTagsMap.put(tag.method_62693(), tag);
        }
    }

    public static <T> class_6885<T> getUnloadedTag(class_6862<T> tagKey) {
        if (unloadedTagsMap == null) {
            return class_6885.method_58563();
        }
        Object content = postponedTagsContentCache.get(tagKey);
        if (content != null) {
            return content;
        }
        class_5321 registry = tagKey.comp_326();
        class_2378.class_10106<?> pendingTags = unloadedTagsMap.get(registry);
        if (pendingTags == null) {
            return class_6885.method_58563();
        }
        content = UnloadedTagHolder.getContent(tagKey, pendingTags);
        postponedTagsContentCache.put(tagKey, (class_6885<?>)content);
        return content;
    }

    private static <T> class_6885<T> getContent(class_6862<T> tagKey, class_2378.class_10106<T> pendingTags) {
        Map contents = postponedContentsCache.computeIfAbsent(pendingTags, key -> {
            if (pendingTags instanceof MappedRegistry$PendingTagsAnonymousAccessor) {
                MappedRegistry$PendingTagsAnonymousAccessor accessor = (MappedRegistry$PendingTagsAnonymousAccessor)pendingTags;
                Map pendingContent = accessor.trimica$val$pendingContents();
                if (pendingContent == null) {
                    Trimica.LOGGER.warn("Pending contents field is null in PendingTags for registry: {}", (Object)pendingTags.method_62693().method_29177());
                    return Map.of();
                }
                return (Map)pendingContent.entrySet().stream().collect(ImmutableMap.toImmutableMap(tagKeyListEntry -> tagKeyListEntry != null ? (class_6862)tagKeyListEntry.getKey() : null, entry -> entry != null ? class_6885.method_40242((List)((List)entry.getValue())) : class_6885.method_58563()));
            }
            Trimica.LOGGER.warn("Unknown PendingTags implementation: {} for registry: {}", (Object)pendingTags.getClass().getName(), (Object)pendingTags.method_62693().method_29177());
            return Map.of();
        });
        class_6885 content = (class_6885)contents.get(tagKey);
        if (content == null) {
            Trimica.LOGGER.warn("No content found for tag {} in registry {}", tagKey, (Object)pendingTags.method_62693().method_29177());
            content = class_6885.method_58563();
        }
        return content;
    }
}

