/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.data;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.equipment.trim.MaterialAssetGroup;
import net.minecraft.world.item.equipment.trim.TrimMaterial;

public final class TrimicaDataFixer {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Holder<TrimMaterial> fixDynamicTrimMaterialSuffix(Holder<TrimMaterial> material) {
        TrimMaterial value;
        if (!(material instanceof Holder.Direct)) return material;
        Holder.Direct direct = (Holder.Direct)material;
        try {
            TrimMaterial trimMaterial;
            value = trimMaterial = (TrimMaterial)direct.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        TrimMaterial fixedMaterial = TrimicaDataFixer.fixDynamicTrimMaterialSuffix(value);
        return Holder.direct((Object)fixedMaterial);
    }

    private static TrimMaterial fixDynamicTrimMaterialSuffix(TrimMaterial value) {
        MaterialAssetGroup assets = value.assets();
        MaterialAssetGroup.AssetInfo base = assets.base();
        Map overrides = assets.overrides();
        MaterialAssetGroup.AssetInfo fixed = TrimicaDataFixer.fixAssetInfo(base);
        for (Map.Entry entry : overrides.entrySet()) {
            MaterialAssetGroup.AssetInfo fixedOverride = TrimicaDataFixer.fixAssetInfo((MaterialAssetGroup.AssetInfo)entry.getValue());
            if (fixedOverride == entry.getValue()) continue;
            overrides.put((ResourceKey)entry.getKey(), fixedOverride);
        }
        if (fixed != base || !overrides.equals(assets.overrides())) {
            MaterialAssetGroup fixedAssets = new MaterialAssetGroup(fixed, overrides);
            return new TrimMaterial(fixedAssets, value.description());
        }
        return value;
    }

    private static MaterialAssetGroup.AssetInfo fixAssetInfo(MaterialAssetGroup.AssetInfo base) {
        String existingSuffix = base.suffix();
        int trimicaStartIndex = existingSuffix.indexOf("trimica/");
        if (trimicaStartIndex == -1) {
            return base;
        }
        String dynamicComponent = existingSuffix.substring(trimicaStartIndex + "trimica/".length());
        int slashIndex = dynamicComponent.indexOf(47);
        int dashIndex = dynamicComponent.indexOf(45);
        if (dashIndex != -1 && (slashIndex == -1 || dashIndex < slashIndex)) {
            String fixedComponent = dynamicComponent.replaceFirst("-", "/");
            String fixedSuffix = "trimica/" + fixedComponent;
            return new MaterialAssetGroup.AssetInfo(fixedSuffix);
        }
        return base;
    }
}

