/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.data.tags;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.mixin.accessor.MappedRegistry$PendingTagsAnonymousAccessor;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public final class UnloadedTagHolder {
    private static final Map<Registry.PendingTags<?>, Map<TagKey<?>, HolderSet<?>>> postponedContentsCache = new HashMap();
    private static final Map<TagKey<?>, HolderSet<?>> postponedTagsContentCache = new HashMap();
    private static Map<ResourceKey<? extends Registry<?>>, Registry.PendingTags<?>> unloadedTagsMap;

    public static void setUnloadedTags(List<Registry.PendingTags<?>> tags) {
        unloadedTagsMap = new HashMap();
        for (Registry.PendingTags<?> tag : tags) {
            unloadedTagsMap.put(tag.key(), tag);
        }
    }

    public static <T> HolderSet<T> getUnloadedTag(TagKey<T> tagKey) {
        if (unloadedTagsMap == null) {
            return HolderSet.empty();
        }
        Object content = postponedTagsContentCache.get(tagKey);
        if (content != null) {
            return content;
        }
        ResourceKey registry = tagKey.registry();
        Registry.PendingTags<?> pendingTags = unloadedTagsMap.get(registry);
        if (pendingTags == null) {
            return HolderSet.empty();
        }
        content = UnloadedTagHolder.getContent(tagKey, pendingTags);
        postponedTagsContentCache.put(tagKey, (HolderSet<?>)content);
        return content;
    }

    private static <T> HolderSet<T> getContent(TagKey<T> tagKey, Registry.PendingTags<T> pendingTags) {
        Map contents = postponedContentsCache.computeIfAbsent(pendingTags, key -> {
            if (pendingTags instanceof MappedRegistry$PendingTagsAnonymousAccessor) {
                MappedRegistry$PendingTagsAnonymousAccessor accessor = (MappedRegistry$PendingTagsAnonymousAccessor)pendingTags;
                Map pendingContent = accessor.trimica$val$pendingContents();
                if (pendingContent == null) {
                    Trimica.LOGGER.warn("Pending contents field is null in PendingTags for registry: {}", (Object)pendingTags.key().location());
                    return Map.of();
                }
                return (Map)pendingContent.entrySet().stream().collect(ImmutableMap.toImmutableMap(tagKeyListEntry -> tagKeyListEntry != null ? (TagKey)tagKeyListEntry.getKey() : null, entry -> entry != null ? HolderSet.direct((List)((List)entry.getValue())) : HolderSet.empty()));
            }
            Trimica.LOGGER.warn("Unknown PendingTags implementation: {} for registry: {}", (Object)pendingTags.getClass().getName(), (Object)pendingTags.key().location());
            return Map.of();
        });
        HolderSet content = (HolderSet)contents.get(tagKey);
        if (content == null) {
            Trimica.LOGGER.warn("No content found for tag {} in registry {}", tagKey, (Object)pendingTags.key().location());
            content = HolderSet.empty();
        }
        return content;
    }
}

