/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.util;

import java.util.function.Consumer;
import java.util.function.Supplier;

public final class Lazy<T> {
    private T value;
    private final Supplier<T> supplier;

    public Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public T get() {
        if (this.value == null) {
            this.value = this.supplier.get();
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(Consumer<T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }
}

