/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.api.impl;

import com.bawnorton.trimica.api.BaseTextureInterceptor;
import com.bawnorton.trimica.api.CraftingRecipeInterceptor;
import com.bawnorton.trimica.api.PaletteInterceptor;
import com.bawnorton.trimica.api.TrimicaApi;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import java.util.PriorityQueue;
import java.util.Queue;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class TrimicaApiImpl
implements TrimicaApi {
    public static final TrimicaApiImpl INSTANCE = new TrimicaApiImpl();
    private final Queue<SortableEndpointHolder<BaseTextureInterceptor>> baseTextureInterceptors = new PriorityQueue<SortableEndpointHolder<BaseTextureInterceptor>>();
    private final Queue<SortableEndpointHolder<CraftingRecipeInterceptor>> craftingRecipeInterceptors = new PriorityQueue<SortableEndpointHolder<CraftingRecipeInterceptor>>();
    private final Queue<SortableEndpointHolder<PaletteInterceptor>> paletteInterceptors = new PriorityQueue<SortableEndpointHolder<PaletteInterceptor>>();

    @Override
    public void registerBaseTextureInterceptor(int priority, BaseTextureInterceptor baseTextureInterceptor) {
        this.baseTextureInterceptors.add(new SortableEndpointHolder<BaseTextureInterceptor>(baseTextureInterceptor, priority));
    }

    @Override
    public void registerCraftingRecipeInterceptor(int priority, CraftingRecipeInterceptor craftingRecipeInterceptor) {
        this.craftingRecipeInterceptors.add(new SortableEndpointHolder<CraftingRecipeInterceptor>(craftingRecipeInterceptor, priority));
    }

    @Override
    public void registerPaletteInterceptor(int priority, PaletteInterceptor paletteInterceptor) {
        this.paletteInterceptors.add(new SortableEndpointHolder<PaletteInterceptor>(paletteInterceptor, priority));
    }

    public ResourceLocation applyBaseTextureInterceptorsForItem(ResourceLocation expectedBaseTexture, ItemStack itemWithTrim, ArmorTrim armourTrim) {
        for (SortableEndpointHolder sortableEndpointHolder : this.baseTextureInterceptors) {
            expectedBaseTexture = ((BaseTextureInterceptor)sortableEndpointHolder.endpoint()).interceptItemTexture(expectedBaseTexture, itemWithTrim, armourTrim);
        }
        return expectedBaseTexture;
    }

    public ResourceLocation applyBaseTextureInterceptorsForArmour(ResourceLocation expectedBaseTexture, ItemStack itemWithTrim, ArmorTrim armourTrim) {
        for (SortableEndpointHolder sortableEndpointHolder : this.baseTextureInterceptors) {
            expectedBaseTexture = ((BaseTextureInterceptor)sortableEndpointHolder.endpoint()).interceptArmourTexture(expectedBaseTexture, itemWithTrim, armourTrim);
        }
        return expectedBaseTexture;
    }

    public ResourceLocation applyBaseTextureInterceptorsForShield(ResourceLocation expectedBaseTexture, DataComponentGetter componentGetter, ArmorTrim armourTrim) {
        for (SortableEndpointHolder sortableEndpointHolder : this.baseTextureInterceptors) {
            expectedBaseTexture = ((BaseTextureInterceptor)sortableEndpointHolder.endpoint()).interceptShieldTexture(expectedBaseTexture, componentGetter, armourTrim);
        }
        return expectedBaseTexture;
    }

    public Ingredient applyCraftingRecipeInterceptorsForAddition(Ingredient current) {
        for (SortableEndpointHolder sortableEndpointHolder : this.craftingRecipeInterceptors) {
            current = ((CraftingRecipeInterceptor)sortableEndpointHolder.endpoint()).getAdditionIngredient(current);
        }
        return current;
    }

    public Ingredient applyCraftingRecipeInterceptorsForBase(Ingredient current) {
        for (SortableEndpointHolder sortableEndpointHolder : this.craftingRecipeInterceptors) {
            current = ((CraftingRecipeInterceptor)sortableEndpointHolder.endpoint()).getBaseIngredient(current);
        }
        return current;
    }

    public TrimPalette applyPaletteInterceptorsForGeneration(TrimPalette generated, TrimMaterial material) {
        for (SortableEndpointHolder sortableEndpointHolder : this.paletteInterceptors) {
            generated = ((PaletteInterceptor)sortableEndpointHolder.endpoint()).interceptGenerated(generated, material);
        }
        return generated;
    }

    public TrimPalette applyPaletteInterceptorsForMaterialAdditions(TrimPalette palette, MaterialAdditions additions) {
        for (SortableEndpointHolder sortableEndpointHolder : this.paletteInterceptors) {
            palette = ((PaletteInterceptor)sortableEndpointHolder.endpoint()).interceptMaterialAdditions(palette, additions);
        }
        return palette;
    }

    private record SortableEndpointHolder<T>(T endpoint, int priority) implements Comparable<SortableEndpointHolder<T>>
    {
        @Override
        public int compareTo(@NotNull SortableEndpointHolder<T> o) {
            return Integer.compare(this.priority, o.priority);
        }
    }
}

