/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.mixin.render;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.mixin.accessor.EquipmentLayerRenderer$TrimSpriteKeyAccessor;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlas;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlases;
import com.bawnorton.trimica.client.texture.TrimArmourSpriteFactory;
import com.bawnorton.trimica.compat.Compat;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.OrderedSubmitNodeCollector;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EquipmentLayerRenderer.class})
public abstract class EquipmentLayerRendererMixin {
    @Shadow
    @Final
    private Function<EquipmentLayerRenderer.TrimSpriteKey, TextureAtlasSprite> trimSpriteLookup;

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/Util;memoize(Ljava/util/function/Function;)Ljava/util/function/Function;", ordinal=1)})
    private Function<EquipmentLayerRenderer.TrimSpriteKey, TextureAtlasSprite> provideRuntimeTextures(Function<EquipmentLayerRenderer.TrimSpriteKey, TextureAtlasSprite> textureGetter, Operation<Function<EquipmentLayerRenderer.TrimSpriteKey, TextureAtlasSprite>> original) {
        return EquipmentLayerRendererMixin.trimica$dynamicProvider((Function)original.call(new Object[]{textureGetter}));
    }

    @Unique
    @NotNull
    private static Function<EquipmentLayerRenderer.TrimSpriteKey, TextureAtlasSprite> trimica$dynamicProvider(Function<EquipmentLayerRenderer.TrimSpriteKey, TextureAtlasSprite> textureGetter) {
        return trimSpriteKey -> {
            TrimMaterial material;
            TextureAtlasSprite sprite = (TextureAtlasSprite)textureGetter.apply((EquipmentLayerRenderer.TrimSpriteKey)trimSpriteKey);
            ProfilerFiller profiler = Profiler.get();
            profiler.push("trimica:armour_runtime_atlas");
            ItemStack stack = TrimArmourSpriteFactory.ITEM_WITH_TRIM_CAPTURE.get();
            MaterialAdditions addition = (MaterialAdditions)stack.getOrDefault(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
            if (!sprite.contents().name().equals((Object)MissingTextureAtlasSprite.getLocation()) && addition.isEmpty()) {
                return sprite;
            }
            RuntimeTrimAtlases atlases = TrimicaClient.getRuntimeAtlases();
            RuntimeTrimAtlas atlas = atlases.getEquipmentAtlas(Minecraft.getInstance().level, material = (TrimMaterial)trimSpriteKey.trim().material().value(), trimSpriteKey.layerType());
            if (atlas == null) {
                return sprite;
            }
            ResourceLocation overlayLocation = trimSpriteKey.spriteId();
            overlayLocation = addition.apply(overlayLocation);
            TrimPattern pattern = (TrimPattern)trimSpriteKey.trim().pattern().value();
            DynamicTrimTextureAtlasSprite dynamicSprite = atlas.getSprite((DataComponentGetter)stack, pattern, overlayLocation);
            profiler.pop();
            return dynamicSprite;
        };
    }

    @ModifyReceiver(method={"renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/resources/ResourceLocation;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;")})
    private <S> ItemStack captureItemWithTrimOrRenderAll(ItemStack instance, DataComponentType<?> dataComponentType, EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> equipmentAsset, Model<? super S> armorModel, S renderState, ItemStack item, PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, @Nullable ResourceLocation texture, int outlineColor, int key, @Cancellable CallbackInfo ci) {
        TrimArmourSpriteFactory.ITEM_WITH_TRIM_CAPTURE.set(instance);
        if (!AdditionalTrims.enableAdditionalTrims) {
            return instance;
        }
        ci.cancel();
        ArrayList<BiConsumer<Boolean, Boolean>> renderers = new ArrayList<BiConsumer<Boolean, Boolean>>();
        boolean isEmissive = false;
        boolean isAnimated = false;
        List<ArmorTrim> trims = AdditionalTrims.getAllTrims((DataComponentGetter)instance);
        for (ArmorTrim armorTrim : trims) {
            RenderType renderType;
            TextureAtlasSprite sprite = this.trimSpriteLookup.apply(EquipmentLayerRenderer$TrimSpriteKeyAccessor.trimica$init(armorTrim, layerType, equipmentAsset));
            if (sprite instanceof DynamicTrimTextureAtlasSprite) {
                DynamicTrimTextureAtlasSprite dynamicSprite = (DynamicTrimTextureAtlasSprite)sprite;
                TrimPalette palette = dynamicSprite.getPalette();
                if (palette != null) {
                    if (palette.isAnimated()) {
                        isAnimated = true;
                    }
                    if (palette.isEmissive()) {
                        isEmissive = true;
                    }
                }
                renderType = dynamicSprite.getRenderType();
            } else {
                renderType = Sheets.armorTrimsSheet((boolean)((TrimPattern)armorTrim.pattern().value()).decal());
            }
            AtomicInteger index = new AtomicInteger(key);
            renderers.add((emissive, animated) -> {
                if (animated.booleanValue()) {
                    Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(sprite));
                }
                nodeCollector.order(index.getAndIncrement()).submitModel(armorModel, renderState, poseStack, renderType, emissive != false ? 0xF000F0 : packedLight, OverlayTexture.NO_OVERLAY, -1, sprite, outlineColor, null);
            });
        }
        for (BiConsumer biConsumer : renderers) {
            biConsumer.accept(isEmissive, isAnimated);
        }
        return instance;
    }

    @WrapOperation(method={"renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/resources/ResourceLocation;II)V"}, at={@At(value="INVOKE:LAST", target="Lnet/minecraft/client/renderer/OrderedSubmitNodeCollector;submitModel(Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/RenderType;IIILnet/minecraft/client/renderer/texture/TextureAtlasSprite;ILnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;)V")})
    private <S> void useDynamicRenderType(OrderedSubmitNodeCollector instance, Model<? super S> model, S renderState, PoseStack poseStack, RenderType renderType, int packedLight, int packedOverlay, int tintColor, TextureAtlasSprite textureAtlasSprite, int outlineColor, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay, Operation<Void> original) {
        if (textureAtlasSprite instanceof DynamicTrimTextureAtlasSprite) {
            DynamicTrimTextureAtlasSprite dynamicSprite = (DynamicTrimTextureAtlasSprite)textureAtlasSprite;
            TrimPalette palette = dynamicSprite.getPalette();
            if (palette != null && palette.isAnimated()) {
                Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(dynamicSprite));
            }
            Object[] objectArray = new Object[11];
            objectArray[0] = instance;
            objectArray[1] = model;
            objectArray[2] = renderState;
            objectArray[3] = poseStack;
            objectArray[4] = dynamicSprite.getRenderType();
            objectArray[5] = palette != null ? (palette.isEmissive() ? 0xF000F0 : packedLight) : packedLight;
            objectArray[6] = packedOverlay;
            objectArray[7] = tintColor;
            objectArray[8] = textureAtlasSprite;
            objectArray[9] = outlineColor;
            objectArray[10] = crumblingOverlay;
            original.call(objectArray);
        } else {
            original.call(new Object[]{instance, model, renderState, poseStack, renderType, packedLight, packedOverlay, tintColor, textureAtlasSprite, outlineColor, crumblingOverlay});
        }
    }
}

