/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.api.impl.TrimicaApiImpl;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.AbstractTrimSpriteFactory;
import com.bawnorton.trimica.client.texture.TrimSpriteMetadata;
import com.bawnorton.trimica.trim.TrimmedType;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureContents;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.jetbrains.annotations.Nullable;

public class TrimItemSpriteFactory
extends AbstractTrimSpriteFactory {
    public TrimItemSpriteFactory() {
        super(16, 16);
    }

    @Override
    @Nullable
    protected TrimSpriteMetadata getSpriteMetadata(ArmorTrim trim, @Nullable DataComponentGetter componentGetter, ResourceLocation texture) {
        if (!(componentGetter instanceof ItemStack)) {
            return null;
        }
        ItemStack stack = (ItemStack)componentGetter;
        TrimmedType trimmedType = TrimmedType.of(stack);
        ResourceKey assetResourceKey = Optional.ofNullable((Equippable)stack.get(DataComponents.EQUIPPABLE)).flatMap(Equippable::assetId).orElse(null);
        TrimMaterial material = (TrimMaterial)trim.material().value();
        TrimPalette palette = TrimicaClient.getPalettes().getOrGeneratePalette(material, (ResourceKey<EquipmentAsset>)assetResourceKey, componentGetter);
        ResourceLocation basePatternTexture = Trimica.enablePerPatternItemTextures ? TrimicaApiImpl.INSTANCE.applyBaseTextureInterceptorsForItem(this.getPatternBasedTrimOverlay(trimmedType, trim), stack, trim) : this.getDefaultTrimOverlay(trimmedType);
        if (basePatternTexture == null) {
            Trimica.LOGGER.error("Provided base pattern texture for trim overlay is null: Pattern[{}]", trim.pattern().unwrapKey().orElse(null));
            return null;
        }
        return new TrimSpriteMetadata(trim, palette, basePatternTexture, trimmedType);
    }

    @Override
    protected NativeImage createImageFromMetadata(TrimSpriteMetadata metadata) {
        TextureContents contents = textureCache.computeIfAbsent(metadata.baseTexture(), k -> {
            try {
                return TextureContents.load((ResourceManager)Minecraft.getInstance().getResourceManager(), (ResourceLocation)k);
            }
            catch (IOException e) {
                TrimmedType trimmedType = metadata.trimmedType();
                ResourceLocation defaultTexture = this.getDefaultTrimOverlay(trimmedType);
                try {
                    return TextureContents.load((ResourceManager)Minecraft.getInstance().getResourceManager(), (ResourceLocation)defaultTexture);
                }
                catch (IOException ex) {
                    ex.addSuppressed(e);
                    Trimica.LOGGER.warn("Expected to find \"{}\" but the texture does of exist, trim overlay will not be added to model", (Object)metadata.baseTexture());
                    return new TextureContents(this.empty(), null);
                }
            }
        });
        return this.createColouredImage(metadata, contents);
    }

    private ResourceLocation getPatternBasedTrimOverlay(TrimmedType trimmedType, ArmorTrim trim) {
        ResourceLocation location = (ResourceLocation)trim.pattern().unwrap().map(ResourceKey::location, TrimPattern::assetId);
        return Trimica.rl("textures/trims/items/%s/%s/%s.png".formatted(trimmedType.getName(), location.getNamespace(), location.getPath()));
    }

    private ResourceLocation getDefaultTrimOverlay(TrimmedType trimmedType) {
        if (trimmedType.isOfArmour()) {
            return ResourceLocation.withDefaultNamespace((String)"textures/trims/items/%s_trim.png".formatted(trimmedType.getName()));
        }
        return Trimica.rl("textures/trims/items/%s/default.png".formatted(trimmedType.getName()));
    }
}

