/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.trim.TrimmedType;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;

public record TrimSpriteMetadata(ArmorTrim trim, TrimPalette palette, ResourceLocation baseTexture, TrimmedType trimmedType) {
    public boolean isAnimated() {
        return this.palette.isAnimated();
    }

    public Path toDebugPath() {
        String pattern = ((TrimPattern)this.trim.pattern().value()).assetId().toString().replace(':', '/');
        String material = ((TrimMaterial)this.trim.material().value()).assets().base().suffix().replace(':', '/');
        String metadata = this.palette.getMetadataString();
        Object baseTexturePath = this.baseTexture.getNamespace() + "/" + this.baseTexture.getPath().replace(':', '/');
        baseTexturePath = ((String)baseTexturePath).substring(0, ((String)baseTexturePath).lastIndexOf(46));
        String fileName = String.format("%s/%s/%s/%s", baseTexturePath, pattern, material, metadata);
        return Path.of(fileName, new String[0]);
    }
}

