/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.trim;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.trim.MaterialAssetGroup;
import net.minecraft.world.item.equipment.trim.TrimMaterial;

public final class TrimMaterialRuntimeRegistry {
    public static final Holder<TrimMaterial> UNKNOWN_HOLDER = Holder.direct((Object)new TrimMaterial(MaterialAssetGroup.create((String)"unknown"), (Component)Component.literal((String)"unknown")));
    private final Map<TrimMaterial, MaterialAdditions> intrinsicAdditions = new HashMap<TrimMaterial, MaterialAdditions>();
    private final Map<TrimMaterial, Item> materialProviders = new HashMap<TrimMaterial, Item>();
    private final Map<ResourceLocation, Holder<TrimMaterial>> materials = new HashMap<ResourceLocation, Holder<TrimMaterial>>();
    public static boolean enableTrimEverything = true;

    public Item guessMaterialProvider(TrimMaterial material) {
        return this.materialProviders.computeIfAbsent(material, k -> {
            String suffix = Trimica.getMaterialRegistry().getSuffix(material);
            int trimicaStartIndex = suffix.indexOf("trimica/");
            if (trimicaStartIndex == -1) {
                return null;
            }
            String materialId = suffix.substring(trimicaStartIndex + "trimica/".length()).replaceFirst("/", ":");
            ResourceLocation id = ResourceLocation.tryParse((String)materialId);
            if (id == null) {
                return null;
            }
            return BuiltInRegistries.ITEM.getOptional(id).orElse(null);
        });
    }

    public Holder<TrimMaterial> getOrCreate(DataComponentGetter getter) {
        ResourceLocation itemKey = (ResourceLocation)getter.get(DataComponents.ITEM_MODEL);
        if (itemKey == null) {
            return UNKNOWN_HOLDER;
        }
        ResourceLocation materialKey = Trimica.rl("generated/%s/%s".formatted(itemKey.getNamespace(), itemKey.getPath()));
        return this.materials.computeIfAbsent(materialKey, k -> {
            String suffix = "trimica/%s/%s".formatted(itemKey.getNamespace(), itemKey.getPath());
            MaterialAssetGroup id = MaterialAssetGroup.create((String)suffix);
            return Holder.direct((Object)new TrimMaterial(id, (Component)Component.translatable((String)"trimica.material", (Object[])new Object[]{getter.getOrDefault(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Unknown"))})));
        });
    }

    public String getSuffix(TrimMaterial material, ResourceKey<EquipmentAsset> assetKey) {
        return assetKey == null ? material.assets().base().suffix() : material.assets().assetId(assetKey).suffix();
    }

    public String getSuffix(TrimMaterial material) {
        return material.assets().base().suffix();
    }

    public void registerMaterialReference(Holder.Reference<TrimMaterial> reference) {
        this.materials.put(reference.key().location(), (Holder<TrimMaterial>)reference);
    }

    public void setIntrinsicAdditions(TrimMaterial material, MaterialAdditions addition) {
        if (addition == null) {
            return;
        }
        this.intrinsicAdditions.put(material, addition);
    }

    public MaterialAdditions getIntrinsicAdditions(TrimMaterial trimMaterial) {
        return this.intrinsicAdditions.getOrDefault(trimMaterial, MaterialAdditions.NONE);
    }

    public void clear() {
        this.materialProviders.clear();
        this.materials.clear();
    }
}

