/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.client.mixin.accessor.AtlasManager$PendingStitchResultsAccessor;
import com.bawnorton.trimica.client.mixin.accessor.SpriteContents$TickerAccessor;
import com.bawnorton.trimica.client.mixin.accessor.SpriteLoaderAccessor;
import com.bawnorton.trimica.client.mixin.accessor.TextureAtlasAccessor;
import com.bawnorton.trimica.client.mixin.accessor.TextureAtlasSprite$TickerAccessor;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.AbstractTrimSpriteFactory;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlases;
import com.bawnorton.trimica.client.texture.TrimSpriteContents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_11697;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import net.minecraft.class_7768;
import net.minecraft.class_8056;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;

public final class RuntimeTrimAtlas
extends class_1059 {
    private final AbstractTrimSpriteFactory spriteFactory;
    private final RuntimeTrimAtlases.TrimFactory trimFactory;
    private final class_1921 renderType;
    private final List<class_7764> dynamicSprites = new ArrayList<class_7764>();
    private final Map<class_2960, TrimPalette> palettes = new HashMap<class_2960, TrimPalette>();
    private final Consumer<RuntimeTrimAtlas> onModified;
    private final class_11697.class_7772 atlasEntry;

    public RuntimeTrimAtlas(class_2960 atlasLocation, AbstractTrimSpriteFactory spriteFactory, RuntimeTrimAtlases.TrimFactory trimFactory, Consumer<RuntimeTrimAtlas> onModified) {
        super(atlasLocation);
        this.spriteFactory = spriteFactory;
        this.trimFactory = trimFactory;
        this.renderType = class_1921.method_25448((class_2960)atlasLocation);
        this.dynamicSprites.add(this.createMissing());
        this.onModified = onModified;
        class_11697.class_11698 atlasConfig = new class_11697.class_11698(atlasLocation, Trimica.rl("generated"), false);
        this.atlasEntry = new class_11697.class_7772((class_1059)this, atlasConfig);
    }

    private class_7764 createMissing() {
        class_2960 missingLocation = class_1047.method_4539();
        return this.spriteFactory.create(missingLocation, null, null).spriteContents();
    }

    @NotNull
    public class_1058 method_4608(@NotNull class_2960 texture) {
        throw new UnsupportedOperationException("Use getSprite(DataComponentGetter, TrimMaterial, ResourceLocation) instead");
    }

    @NotNull
    public DynamicTrimTextureAtlasSprite getSprite(class_9473 componentGetter, class_8056 pattern, class_2960 texture) {
        Map<class_2960, class_1058> texturesByName = this.asAccessor().trimica$texturesByName();
        class_1058 sprite = texturesByName.get(texture);
        if (sprite == null) {
            TrimTextureAtlasSprite trimTextureAtlasSprite = this.createSprite(componentGetter, pattern, texture);
            sprite = trimTextureAtlasSprite.sprite();
            TrimPalette palette = trimTextureAtlasSprite.palette();
            this.palettes.put(texture, palette);
        }
        return new DynamicTrimTextureAtlasSprite(sprite, this.renderType, this.palettes.get(texture));
    }

    private TrimTextureAtlasSprite createSprite(class_9473 componentGetter, class_8056 pattern, class_2960 texture) {
        TrimSpriteContents sprite = this.spriteFactory.create(texture, this.trimFactory.create(pattern), componentGetter);
        this.dynamicSprites.add(sprite.spriteContents());
        this.stitchAndUpload();
        this.onModified.accept(this);
        class_310 client = class_310.method_1551();
        client.method_1531().method_4616(this.method_24106(), (class_1044)this);
        return new TrimTextureAtlasSprite(this.asAccessor().trimica$texturesByName().get(texture), sprite.palette());
    }

    private void stitchAndUpload() {
        ArrayList<class_11697.class_11699> pendingStitches = new ArrayList<class_11697.class_11699>();
        HashMap<class_2960, CompletableFuture<class_7766.class_7767>> stitchFutureById = new HashMap<class_2960, CompletableFuture<class_7766.class_7767>>();
        ArrayList<CompletionStage> allReadyToUpload = new ArrayList<CompletionStage>();
        CompletableFuture preparations = new CompletableFuture();
        stitchFutureById.put(this.method_24106(), preparations);
        pendingStitches.add(new class_11697.class_11699(this.atlasEntry, preparations));
        allReadyToUpload.add(preparations.thenCompose(class_7766.class_7767::comp_1045));
        AtlasManager$PendingStitchResultsAccessor pendingStitchResults = (AtlasManager$PendingStitchResultsAccessor)AtlasManager$PendingStitchResultsAccessor.trimica$init(pendingStitches, stitchFutureById, CompletableFuture.allOf(allReadyToUpload.toArray(new CompletableFuture[0])));
        SpriteLoaderAccessor loader = (SpriteLoaderAccessor)class_7766.method_45837((class_1059)this);
        pendingStitchResults.trimica$pendingStitches().forEach(stitch -> {
            class_7766.class_7767 stitched = loader.trimica$stitch(this.dynamicSprites, 0, (Executor)class_156.method_18349());
            if (stitched != null) {
                stitch.comp_4559().complete(stitched);
            } else {
                stitch.comp_4559().completeExceptionally(new RuntimeException("Failed to stitch dynamic trim atlas"));
            }
        });
        ((CompletableFuture)pendingStitchResults.trimica$allReadyToUpload().thenApply(o -> ((class_11697.class_11700)pendingStitchResults).method_73037())).join();
    }

    public void method_4601() {
        TextureAtlasAccessor accessor = this.asAccessor();
        accessor.trimica$sprites(List.of());
        accessor.trimica$animatedTextures(List.of());
        accessor.trimica$texturesByName(Map.of());
        accessor.trimica$missingSprite(null);
    }

    public void resetFrames() {
        List<class_1058.class_7770> tickers = this.asAccessor().trimica$animatedTextures();
        for (class_1058.class_7770 ticker : tickers) {
            TextureAtlasSprite$TickerAccessor accessor;
            class_7768 class_77682;
            if (!(ticker instanceof TextureAtlasSprite$TickerAccessor) || !((class_77682 = (accessor = (TextureAtlasSprite$TickerAccessor)ticker).trimica$ticker()) instanceof SpriteContents$TickerAccessor)) continue;
            SpriteContents$TickerAccessor spriteTicker = (SpriteContents$TickerAccessor)class_77682;
            spriteTicker.trimica$frame(0);
        }
    }

    private TextureAtlasAccessor asAccessor() {
        return (TextureAtlasAccessor)((Object)this);
    }

    public void clear() {
        this.spriteFactory.clear();
        this.dynamicSprites.clear();
        this.dynamicSprites.add(this.createMissing());
        this.method_4601();
    }

    private record TrimTextureAtlasSprite(class_1058 sprite, TrimPalette palette) {
    }
}

