/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.api.client.impl;

import com.bawnorton.trimica.api.BaseTextureInterceptor;
import com.bawnorton.trimica.api.PaletteInterceptor;
import com.bawnorton.trimica.api.client.TrimicaClientApi;
import com.bawnorton.trimica.api.client.TrimicaRenderer;
import com.bawnorton.trimica.api.client.impl.TrimicaRendererImpl;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.util.SortableEndpointHolder;
import java.util.PriorityQueue;
import java.util.Queue;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class TrimicaClientApiImpl
implements TrimicaClientApi {
    public static final TrimicaClientApiImpl INSTANCE = new TrimicaClientApiImpl();
    private final TrimicaRenderer renderer = new TrimicaRendererImpl();
    private final Queue<SortableEndpointHolder<BaseTextureInterceptor>> baseTextureInterceptors = new PriorityQueue<SortableEndpointHolder<BaseTextureInterceptor>>();
    private final Queue<SortableEndpointHolder<PaletteInterceptor>> paletteInterceptors = new PriorityQueue<SortableEndpointHolder<PaletteInterceptor>>();

    @Override
    public TrimicaRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void registerBaseTextureInterceptor(int priority, BaseTextureInterceptor baseTextureInterceptor) {
        this.baseTextureInterceptors.add(new SortableEndpointHolder<BaseTextureInterceptor>(baseTextureInterceptor, priority));
    }

    @Override
    public void registerPaletteInterceptor(int priority, PaletteInterceptor paletteInterceptor) {
        this.paletteInterceptors.add(new SortableEndpointHolder<PaletteInterceptor>(paletteInterceptor, priority));
    }

    public ResourceLocation applyBaseTextureInterceptorsForItem(ResourceLocation expectedBaseTexture, ItemStack itemWithTrim, ArmorTrim armourTrim) {
        for (SortableEndpointHolder sortableEndpointHolder : this.baseTextureInterceptors) {
            expectedBaseTexture = ((BaseTextureInterceptor)sortableEndpointHolder.endpoint()).interceptItemTexture(expectedBaseTexture, itemWithTrim, armourTrim);
        }
        return expectedBaseTexture;
    }

    public ResourceLocation applyBaseTextureInterceptorsForArmour(ResourceLocation expectedBaseTexture, ItemStack itemWithTrim, ArmorTrim armourTrim) {
        for (SortableEndpointHolder sortableEndpointHolder : this.baseTextureInterceptors) {
            expectedBaseTexture = ((BaseTextureInterceptor)sortableEndpointHolder.endpoint()).interceptArmourTexture(expectedBaseTexture, itemWithTrim, armourTrim);
        }
        return expectedBaseTexture;
    }

    public ResourceLocation applyBaseTextureInterceptorsForShield(ResourceLocation expectedBaseTexture, DataComponentGetter componentGetter, ArmorTrim armourTrim) {
        for (SortableEndpointHolder sortableEndpointHolder : this.baseTextureInterceptors) {
            expectedBaseTexture = ((BaseTextureInterceptor)sortableEndpointHolder.endpoint()).interceptShieldTexture(expectedBaseTexture, componentGetter, armourTrim);
        }
        return expectedBaseTexture;
    }

    public TrimPalette applyPaletteInterceptorsForGeneration(TrimPalette generated, TrimMaterial material, MaterialAdditions materialAdditions) {
        for (SortableEndpointHolder sortableEndpointHolder : this.paletteInterceptors) {
            generated = ((PaletteInterceptor)sortableEndpointHolder.endpoint()).interceptPaletteGeneration(generated, material, materialAdditions);
        }
        return generated;
    }
}

