/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.api.client.impl;

import com.bawnorton.trimica.api.client.TrimicaRenderer;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.compat.Compat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;

public final class TrimicaRendererImpl
implements TrimicaRenderer {
    @Override
    public void submitShieldTrim(ModelPart plate, DataComponentMap components, PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, int packedOverlay, boolean hasFoil, int outlineColor) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("trimica:shield");
        List<DynamicTrimTextureAtlasSprite> dynamicSprites = TrimicaClient.getRuntimeAtlases().getShieldSprites(Minecraft.getInstance().level, (DataComponentGetter)components);
        for (DynamicTrimTextureAtlasSprite dynamicSprite : dynamicSprites) {
            int light;
            TrimPalette palette = dynamicSprite.getPalette();
            int n = palette == null ? packedLight : (light = palette.isEmissive() ? 0xF000F0 : packedLight);
            if (palette != null && palette.isAnimated()) {
                Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(dynamicSprite));
            }
            nodeCollector.submitModelPart(plate, poseStack, dynamicSprite.getRenderType(), light, packedOverlay, (TextureAtlasSprite)dynamicSprite, false, hasFoil, -1, null, outlineColor);
        }
        profiler.pop();
    }
}

