/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.colour;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class OkLabHelper {
    private static final double[][] M1 = new double[][]{{0.4122214708, 0.5363325363, 0.0514459929}, {0.2119034982, 0.6806995451, 0.1073969566}, {0.0883024619, 0.2817188376, 0.6299787005}};
    private static final double[][] M2 = new double[][]{{0.2104542553, 0.793617785, -0.0040720468}, {1.9779984951, -2.428592205, 0.4505937099}, {0.0259040371, 0.7827717662, -0.808675766}};
    private static final double[][] M2_INV = new double[][]{{1.0, 0.3963377774, 0.2158037573}, {1.0, -0.1055613458, -0.0638541728}, {1.0, -0.0894841775, -1.291485548}};
    private static final double[][] M1_INV = new double[][]{{4.0767416621, -3.3077115913, 0.2309699292}, {-1.2684380046, 2.6097574011, -0.3413193965}, {-0.0041960863, -0.7034186147, 1.707614701}};

    public static double[] rgbToOklab(int rgb) {
        double r = (double)(rgb >> 16 & 0xFF) / 255.0;
        double g = (double)(rgb >> 8 & 0xFF) / 255.0;
        double b = (double)(rgb & 0xFF) / 255.0;
        return OkLabHelper.rgbToOklab(r, g, b);
    }

    public static double[] rgbToOklab(double r, double g, double b) {
        double r_linear = OkLabHelper.srgbToLinear(r);
        double g_linear = OkLabHelper.srgbToLinear(g);
        double b_linear = OkLabHelper.srgbToLinear(b);
        double l = M1[0][0] * r_linear + M1[0][1] * g_linear + M1[0][2] * b_linear;
        double m = M1[1][0] * r_linear + M1[1][1] * g_linear + M1[1][2] * b_linear;
        double s = M1[2][0] * r_linear + M1[2][1] * g_linear + M1[2][2] * b_linear;
        double l_ = Math.cbrt(Math.max(0.0, l));
        double m_ = Math.cbrt(Math.max(0.0, m));
        double s_ = Math.cbrt(Math.max(0.0, s));
        double L = M2[0][0] * l_ + M2[0][1] * m_ + M2[0][2] * s_;
        double a = M2[1][0] * l_ + M2[1][1] * m_ + M2[1][2] * s_;
        double b_ok = M2[2][0] * l_ + M2[2][1] * m_ + M2[2][2] * s_;
        return new double[]{L, a, b_ok};
    }

    public static List<double[]> rgbToOklab(List<Integer> rgbs) {
        ArrayList<double[]> oklabList = new ArrayList<double[]>(rgbs.size());
        for (int rgb : rgbs) {
            double[] oklab = OkLabHelper.rgbToOklab(rgb);
            oklabList.add(oklab);
        }
        return oklabList;
    }

    public static int oklabToRgb(double[] oklab) {
        double L = oklab[0];
        double a = oklab[1];
        double b = oklab[2];
        double[] rgb = OkLabHelper.oklabToRgb(L, a, b);
        int r = (int)Math.round(rgb[0] * 255.0);
        int g = (int)Math.round(rgb[1] * 255.0);
        int b_srgb = (int)Math.round(rgb[2] * 255.0);
        return r << 16 | g << 8 | b_srgb;
    }

    public static double[] oklabToRgb(double L, double a, double b) {
        double l_ = M2_INV[0][0] * L + M2_INV[0][1] * a + M2_INV[0][2] * b;
        double m_ = M2_INV[1][0] * L + M2_INV[1][1] * a + M2_INV[1][2] * b;
        double s_ = M2_INV[2][0] * L + M2_INV[2][1] * a + M2_INV[2][2] * b;
        double l = l_ * l_ * l_;
        double m = m_ * m_ * m_;
        double s = s_ * s_ * s_;
        double r_linear = M1_INV[0][0] * l + M1_INV[0][1] * m + M1_INV[0][2] * s;
        double g_linear = M1_INV[1][0] * l + M1_INV[1][1] * m + M1_INV[1][2] * s;
        double b_linear = M1_INV[2][0] * l + M1_INV[2][1] * m + M1_INV[2][2] * s;
        double r = OkLabHelper.linearToSrgb(r_linear);
        double g = OkLabHelper.linearToSrgb(g_linear);
        double b_srgb = OkLabHelper.linearToSrgb(b_linear);
        r = Math.max(0.0, Math.min(1.0, r));
        g = Math.max(0.0, Math.min(1.0, g));
        b_srgb = Math.max(0.0, Math.min(1.0, b_srgb));
        return new double[]{r, g, b_srgb};
    }

    public static List<Integer> okLabToRgb(List<double[]> okLabColours) {
        ArrayList<Integer> rgbList = new ArrayList<Integer>(okLabColours.size());
        for (double[] okLab : okLabColours) {
            int rgb = OkLabHelper.oklabToRgb(okLab);
            rgbList.add(rgb);
        }
        return rgbList;
    }

    private static double srgbToLinear(double val_srgb) {
        if (val_srgb <= 0.04045) {
            return val_srgb / 12.92;
        }
        return Math.pow((val_srgb + 0.055) / 1.055, 2.4);
    }

    private static double linearToSrgb(double val_linear) {
        if (val_linear <= 0.0031308) {
            return 12.92 * val_linear;
        }
        return 1.055 * Math.pow(val_linear, 0.4166666666666667) - 0.055;
    }

    @NotNull
    public static List<double[]> strechOkLab(int targetSize, int size, List<double[]> oklabPalette) {
        ArrayList<double[]> stretchedOKLab = new ArrayList<double[]>(targetSize);
        for (int i = 0; i < targetSize; ++i) {
            double t = (double)i / (double)(targetSize - 1);
            int index1 = (int)Math.floor(t * (double)(size - 1));
            int index2 = Math.min(index1 + 1, size - 1);
            double blend = t * (double)(size - 1) - (double)index1;
            double[] colour1 = oklabPalette.get(index1);
            double[] colour2 = oklabPalette.get(index2);
            double[] interpolatedColour = OkLabHelper.interpolateOKLab(colour1, colour2, blend);
            stretchedOKLab.add(interpolatedColour);
        }
        return stretchedOKLab;
    }

    public static double[] interpolateOKLab(double[] colour1, double[] colour2, double blend) {
        double[] result = new double[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = colour1[i] * (1.0 - blend) + colour2[i] * blend;
        }
        return result;
    }
}

