/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.mixin;

import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.data.tags.TrimicaTags;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.SequencedCollection;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemStack.class}, priority=1500)
public abstract class ItemStackMixin
implements DataComponentHolder {
    @Shadow
    public abstract boolean is(TagKey<Item> var1);

    @WrapOperation(method={"addDetailsToTooltip"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="TRIM", field={"Lnet/minecraft/core/component/DataComponents;TRIM:Lnet/minecraft/core/component/DataComponentType;"})
    @Expression(value={"this.?(TRIM, ?, ?, ?, ?)"})
    private <T> void addTrimicaAdditionLines(ItemStack instance, DataComponentType<T> component, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag, Operation<Void> original) {
        if (AdditionalTrims.enableAdditionalTrims) {
            SequencedCollection trims = AdditionalTrims.getAllTrims((DataComponentGetter)this).reversed();
            if (!trims.isEmpty()) {
                tooltipAdder.accept((Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"smithing_template.upgrade"))).withStyle(ChatFormatting.GRAY));
            }
            for (ArmorTrim trim : trims) {
                Style style;
                TrimPattern trimPattern = (TrimPattern)trim.pattern().value();
                TrimMaterial material = (TrimMaterial)trim.material().value();
                TrimPalette palette = TrimicaClient.getPalettes().getPalette(material, null, (DataComponentGetter)this);
                if (palette == null) {
                    palette = TrimPalette.DEFAULT;
                }
                if ((style = material.description().getStyle()).getColor() == null || palette.isAnimated()) {
                    style = style.withColor(palette.getTooltipColour());
                }
                MutableComponent patternComponent = CommonComponents.space().append((Component)trimPattern.description().copy().withStyle(style));
                MutableComponent materialComponent = CommonComponents.space().append((Component)material.description().copy().withStyle(style));
                tooltipAdder.accept((Component)patternComponent);
                tooltipAdder.accept((Component)materialComponent);
            }
        } else {
            original.call(new Object[]{instance, component, context, tooltipDisplay, tooltipAdder, tooltipFlag});
        }
        if (MaterialAdditions.enableMaterialAdditions) {
            MaterialAdditions additions = (MaterialAdditions)this.getOrDefault(MaterialAdditions.TYPE, MaterialAdditions.NONE);
            ArrayList<MutableComponent> additionsList = new ArrayList<MutableComponent>();
            for (ResourceLocation resourceLocation : additions.additionKeys()) {
                Item additionItem = (Item)BuiltInRegistries.ITEM.getValue(resourceLocation);
                if (additionItem == Items.AIR) continue;
                additionsList.add(CommonComponents.space().append(additionItem.getName()).withStyle(ChatFormatting.AQUA));
            }
            if (!additionsList.isEmpty()) {
                tooltipAdder.accept((Component)Component.translatable((String)"trimica.material_addition_list").withStyle(ChatFormatting.GRAY));
                for (Component component2 : additionsList) {
                    tooltipAdder.accept(component2);
                }
            }
        }
        if (this.is(TrimicaTags.MATERIAL_ADDITIONS) && MaterialAdditions.enableMaterialAdditions) {
            if (Minecraft.getInstance().hasShiftDown()) {
                tooltipAdder.accept((Component)Component.translatable((String)"trimica.material_addition.shift").withStyle(ChatFormatting.GOLD));
                tooltipAdder.accept((Component)CommonComponents.space().append((Component)Component.translatable((String)"trimica.material_addition.details.1").withStyle(ChatFormatting.GRAY)));
                tooltipAdder.accept((Component)CommonComponents.space().append((Component)Component.translatable((String)"trimica.material_addition.details.2").withStyle(ChatFormatting.RED)));
            } else {
                tooltipAdder.accept((Component)Component.translatable((String)"trimica.material_addition.no_shift").withStyle(ChatFormatting.GOLD));
            }
        }
        if (this.is((TagKey<Item>)ItemTags.TRIM_MATERIALS)) {
            tooltipAdder.accept((Component)Component.translatable((String)"trimica.trim_material").withStyle(ChatFormatting.GREEN));
        }
    }
}

