/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.palette;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.client.colour.ColourGroup;
import com.bawnorton.trimica.client.colour.ColourHSB;
import com.bawnorton.trimica.client.colour.OkLabHelper;
import com.bawnorton.trimica.client.mixin.accessor.BlockModelWrapperAccessor;
import com.bawnorton.trimica.client.mixin.accessor.CompositeModelAccessor;
import com.bawnorton.trimica.client.mixin.accessor.ConditionalItemModelAccessor;
import com.bawnorton.trimica.client.mixin.accessor.ItemModelResolverAccessor;
import com.bawnorton.trimica.client.mixin.accessor.RangeSelectItemModelAccessor;
import com.bawnorton.trimica.client.mixin.accessor.SelectItemModelAccessor;
import com.bawnorton.trimica.client.mixin.accessor.SpecialModelWrapperAccessor;
import com.bawnorton.trimica.client.mixin.accessor.SpriteContentsAccessor;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.MissingItemModel;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureContents;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import org.jetbrains.annotations.NotNull;

public final class TrimPaletteGenerator {
    private static final Map<TrimMaterial, TrimPalette> TRIM_PALETTES = new HashMap<TrimMaterial, TrimPalette>();
    private static final Map<TrimMaterial, TrimPalette> BUILT_IN_PALETTES = new HashMap<TrimMaterial, TrimPalette>();

    @NotNull
    public TrimPalette generatePalette(TrimMaterial material, ResourceKey<EquipmentAsset> assetKey) {
        Item materialProvider = Trimica.getMaterialRegistry().guessMaterialProvider(material);
        if (materialProvider == null) {
            return this.generatePaletteFromBuiltIn(material, assetKey);
        }
        if (!TrimMaterialRuntimeRegistry.enableTrimEverything) {
            Trimica.LOGGER.warn("Trim palette generation is disabled, cannot generate palette for material: {}", (Object)BuiltInRegistries.ITEM.getKey((Object)materialProvider));
            return TrimPalette.DISABLED;
        }
        ItemModelResolver modelResolver = Minecraft.getInstance().getItemModelResolver();
        ItemModel model = ((ItemModelResolverAccessor)modelResolver).trimica$modelGetter().apply(BuiltInRegistries.ITEM.getKey((Object)materialProvider));
        return this.generatePaletteFromModel(material, assetKey, model);
    }

    @NotNull
    private TrimPalette generatePaletteFromBuiltIn(TrimMaterial material, ResourceKey<EquipmentAsset> assetKey) {
        return BUILT_IN_PALETTES.computeIfAbsent(material, k -> {
            List<Integer> colours = this.getColoursFromBuiltIn(material, assetKey);
            if (colours.isEmpty()) {
                return TrimPalette.MISSING;
            }
            return new TrimPalette(colours, true);
        });
    }

    private List<Integer> getColoursFromBuiltIn(TrimMaterial material, ResourceKey<EquipmentAsset> assetKey) {
        List<Integer> list;
        block11: {
            Minecraft minecraft = Minecraft.getInstance();
            ResourceManager resourceManager = minecraft.getResourceManager();
            ClientLevel level = minecraft.level;
            if (level == null) {
                return List.of();
            }
            Registry lookup = level.registryAccess().lookup(Registries.TRIM_MATERIAL).orElse(null);
            if (lookup == null) {
                return List.of();
            }
            ResourceLocation materialId = lookup.getKey((Object)material);
            if (materialId == null && (materialId = (ResourceLocation)lookup.entrySet().stream().filter(e -> ((TrimMaterial)e.getValue()).equals((Object)material)).findFirst().map(Map.Entry::getKey).map(ResourceKey::location).orElse(null)) == null) {
                return List.of();
            }
            String suffix = Trimica.getMaterialRegistry().getSuffix(material, assetKey);
            TextureContents contents = TextureContents.load((ResourceManager)resourceManager, (ResourceLocation)materialId.withPath("textures/trims/color_palettes/%s.png".formatted(suffix)));
            try {
                NativeImage image = contents.image();
                list = this.extractColoursFromBuiltIn(image);
                if (contents == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    Trimica.LOGGER.error("Failed to load trim palette texture", (Throwable)e2);
                    return List.of();
                }
            }
            contents.close();
        }
        return list;
    }

    private List<Integer> extractColoursFromBuiltIn(NativeImage builtInImage) {
        int width = builtInImage.getWidth();
        int height = builtInImage.getHeight();
        if (width != 8 || height != 1) {
            return List.of();
        }
        ArrayList<Integer> colours = new ArrayList<Integer>(8);
        for (int x = 0; x < width; ++x) {
            int colour = builtInImage.getPixel(x, 0);
            colours.add(colour);
        }
        return colours;
    }

    private TrimPalette generatePaletteFromModel(TrimMaterial material, ResourceKey<EquipmentAsset> assetKey, ItemModel model) {
        return TRIM_PALETTES.computeIfAbsent(material, key -> {
            List<Integer> colours = this.getColoursFromModel(model);
            if (colours.isEmpty()) {
                Trimica.LOGGER.warn("Trim palette colour could of determined for {}", (Object)Trimica.getMaterialRegistry().getSuffix(material, assetKey));
                return TrimPalette.DEFAULT;
            }
            colours = this.getDominantColours(colours);
            colours = this.sortPalette(colours);
            colours = this.stretchPalette(colours);
            return new TrimPalette(colours);
        });
    }

    private List<Integer> getColoursFromModel(ItemModel model) {
        ItemModel itemModel = model;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockModelWrapperAccessor.class, SelectItemModelAccessor.class, SpecialModelWrapperAccessor.class, CompositeModelAccessor.class, ConditionalItemModelAccessor.class, RangeSelectItemModelAccessor.class}, (Object)itemModel, n)) {
            case 0 -> {
                BlockModelWrapperAccessor blockModelWrapperAccessor = (BlockModelWrapperAccessor)itemModel;
                yield this.getColoursFromQuads(blockModelWrapperAccessor.trimica$quads());
            }
            case 1 -> {
                SelectItemModelAccessor selectItemModelAccessor = (SelectItemModelAccessor)itemModel;
                yield this.getColoursFromModel(selectItemModelAccessor.trimica$models().get(null, null));
            }
            case 2 -> {
                SpecialModelWrapperAccessor specialModelWrapperAccessor = (SpecialModelWrapperAccessor)itemModel;
                ModelRenderProperties properties = specialModelWrapperAccessor.trimica$properties();
                int[] colours = this.extractColours(properties.particleIcon());
                yield Arrays.stream(colours).boxed().toList();
            }
            case 3 -> {
                CompositeModelAccessor compositeModelAccessor = (CompositeModelAccessor)itemModel;
                yield this.getColoursFromModel(compositeModelAccessor.trimica$models().getFirst());
            }
            case 4 -> {
                ConditionalItemModelAccessor conditionalItemModelAccessor = (ConditionalItemModelAccessor)itemModel;
                yield this.getColoursFromModel(conditionalItemModelAccessor.trimica$onFalse());
            }
            case 5 -> {
                RangeSelectItemModelAccessor rangeSelectItemModelAccessor = (RangeSelectItemModelAccessor)itemModel;
                ItemModel fallback = rangeSelectItemModelAccessor.trimica$fallback();
                if (!(fallback instanceof MissingItemModel)) {
                    yield this.getColoursFromModel(fallback);
                }
                ItemModel[] models = rangeSelectItemModelAccessor.trimica$models();
                if (models.length > 0) {
                    yield this.getColoursFromModel(models[0]);
                }
                yield Collections.emptyList();
            }
            case -1 -> Collections.emptyList();
            default -> {
                Trimica.LOGGER.warn("Cannot extract colours from unknown item model type: {}", (Object)model.getClass().getName());
                yield Collections.emptyList();
            }
        };
    }

    private List<Integer> getDominantColours(List<Integer> colours) {
        List<ColourHSB> hsbColours = ColourHSB.fromARGB(colours);
        ArrayList<ColourGroup> groups = new ArrayList<ColourGroup>();
        for (ColourHSB colour : hsbColours) {
            boolean foundGroup = false;
            for (ColourGroup group : groups) {
                if (!group.isSimilar(colour)) continue;
                group.addMember(colour);
                foundGroup = true;
                break;
            }
            if (foundGroup) continue;
            groups.add(new ColourGroup(colour));
        }
        Collections.sort(groups);
        ArrayList<ColourHSB> dominantColours = new ArrayList<ColourHSB>();
        int count = 0;
        for (ColourGroup group : groups) {
            if (count >= 8) break;
            dominantColours.add(group.getRepresentative());
            ++count;
        }
        ArrayList<Integer> dominantRGB = new ArrayList<Integer>();
        for (ColourHSB colour : dominantColours) {
            dominantRGB.add(colour.rgb());
        }
        return dominantRGB;
    }

    private List<Integer> sortPalette(List<Integer> colours) {
        return ColourHSB.fromARGB(colours).stream().sorted().map(ColourHSB::rgb).toList();
    }

    private List<Integer> stretchPalette(List<Integer> palette) {
        int targetSize;
        int size = palette.size();
        if (size >= (targetSize = 8)) {
            return palette;
        }
        List<double[]> oklabPalette = OkLabHelper.rgbToOklab(palette);
        List<double[]> stretchedOKLab = OkLabHelper.strechOkLab(targetSize, size, oklabPalette);
        return OkLabHelper.okLabToRgb(stretchedOKLab);
    }

    @NotNull
    private List<Integer> getColoursFromQuads(List<BakedQuad> quads) {
        ArrayList<Integer> colours = new ArrayList<Integer>(quads.size() * 16 * 16);
        for (BakedQuad bakedQuad : quads) {
            int[] colourData;
            for (int colour : colourData = this.extractColours(bakedQuad.sprite())) {
                colours.add(colour);
            }
        }
        return colours.stream().filter(i -> i != 0).toList();
    }

    private int[] extractColours(TextureAtlasSprite sprite) {
        NativeImage spriteImage = ((SpriteContentsAccessor)sprite.contents()).trimica$originalImage();
        int width = spriteImage.getWidth();
        int height = spriteImage.getHeight();
        int[] colourData = new int[width * height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int packed;
                int argb = spriteImage.getPixel(x, y);
                int alpha = ARGB.alpha((int)argb);
                if (alpha == 0) continue;
                int red = ARGB.red((int)argb);
                int green = ARGB.green((int)argb);
                int blue = ARGB.blue((int)argb);
                colourData[x + y * width] = packed = red << 16 | green << 8 | blue;
            }
        }
        return colourData;
    }

    public void clear() {
        TRIM_PALETTES.clear();
        BUILT_IN_PALETTES.clear();
    }
}

