/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.palette;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.api.client.impl.TrimicaClientApiImpl;
import com.bawnorton.trimica.api.impl.TrimicaApiImpl;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.palette.TrimPaletteGenerator;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import org.jetbrains.annotations.Nullable;

public final class TrimPalettes {
    private final ConcurrentMap<ResourceLocation, TrimPalette> cache = new ConcurrentHashMap<ResourceLocation, TrimPalette>();
    private final TrimPaletteGenerator generator = new TrimPaletteGenerator();

    public TrimPalette getOrGeneratePalette(TrimMaterial material, @Nullable ResourceKey<EquipmentAsset> assetKey, @Nullable DataComponentGetter componentGetter) {
        MaterialAdditions additions;
        ResourceLocation key = Trimica.rl(Trimica.getMaterialRegistry().getSuffix(material, assetKey));
        if (componentGetter == null || !MaterialAdditions.enableMaterialAdditions) {
            additions = MaterialAdditions.NONE;
        } else {
            additions = Trimica.getMaterialRegistry().getIntrinsicAdditions(material).and((MaterialAdditions)componentGetter.get(MaterialAdditions.TYPE));
            key = additions.apply(key);
        }
        return this.cache.computeIfAbsent(key, k -> {
            TrimPalette palette = this.generator.generatePalette(material, assetKey);
            palette = TrimicaApiImpl.INSTANCE.applyPaletteInterceptorsForMaterialAdditions(palette, additions);
            palette = TrimicaApiImpl.INSTANCE.applyPaletteInterceptorsForGeneration(palette, material);
            return TrimicaClientApiImpl.INSTANCE.applyPaletteInterceptorsForGeneration(palette, material, additions);
        });
    }

    @Nullable
    public TrimPalette getPalette(TrimMaterial material, ResourceKey<EquipmentAsset> assetKey, @Nullable DataComponentGetter componentGetter) {
        String suffix = Trimica.getMaterialRegistry().getSuffix(material, assetKey);
        ResourceLocation key = Trimica.rl(suffix);
        if (componentGetter != null && MaterialAdditions.enableMaterialAdditions) {
            MaterialAdditions addition = (MaterialAdditions)componentGetter.getOrDefault(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
            key = addition.apply(key);
        }
        return (TrimPalette)this.cache.get(key);
    }

    public void clear() {
        this.cache.clear();
        this.generator.clear();
    }
}

