/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.item;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.TrimicaToggles;
import com.bawnorton.trimica.item.trim.TrimicaTrimMaterials;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;

public final class TrimicaItems {
    private static final List<ItemHolder> ITEMS = new ArrayList<ItemHolder>();
    public static final Item RAINBOWIFIER;
    public static final Item ANIMATOR;
    public static final Item FAKE_ADDITION;

    public static void forEach(BiConsumer<ResourceKey<Item>, Item> consumer) {
        for (ItemHolder itemHolder : ITEMS) {
            consumer.accept(itemHolder.key(), itemHolder.item());
        }
    }

    private static Item create(String name, Function<Item.Properties, Item> factory, Item.Properties properties) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Trimica.rl(name));
        properties.setId(key);
        Item item = factory.apply(properties);
        ITEMS.add(new ItemHolder((ResourceKey<Item>)key, item));
        return item;
    }

    static {
        if (TrimicaToggles.enableItems) {
            RAINBOWIFIER = TrimicaToggles.enableRainbowifier ? TrimicaItems.create("rainbowifier", Item::new, new Item.Properties().rarity(Rarity.UNCOMMON).trimMaterial(TrimicaTrimMaterials.RAINBOW)) : null;
            ANIMATOR = TrimicaToggles.enableAnimator ? TrimicaItems.create("animator", Item::new, new Item.Properties().rarity(Rarity.UNCOMMON)) : null;
            FAKE_ADDITION = TrimicaItems.create("fake_addition", Item::new, new Item.Properties());
        } else {
            RAINBOWIFIER = null;
            ANIMATOR = null;
            FAKE_ADDITION = null;
        }
    }

    private record ItemHolder(ResourceKey<Item> key, Item item) {
    }
}

