/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.item.component;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record MaterialAdditions(List<ResourceLocation> additionKeys) {
    public static final MaterialAdditions NONE = new MaterialAdditions(List.of());
    public static boolean enableMaterialAdditions = true;
    public static DataComponentType<MaterialAdditions> TYPE;
    public static final Codec<MaterialAdditions> CODEC;
    public static final StreamCodec<ByteBuf, MaterialAdditions> STREAM_CODEC;

    public MaterialAdditions(ResourceLocation addition) {
        this(List.of(addition));
    }

    public MaterialAdditions and(ResourceLocation addition) {
        ArrayList<ResourceLocation> additions = new ArrayList<ResourceLocation>(this.additionKeys);
        if (additions.contains(addition)) {
            return this;
        }
        additions.add(addition);
        return new MaterialAdditions(additions);
    }

    public MaterialAdditions and(MaterialAdditions additions) {
        if (additions == null || additions.isEmpty()) {
            return this;
        }
        ArrayList<ResourceLocation> newAdditions = new ArrayList<ResourceLocation>(this.additionKeys);
        for (ResourceLocation addition : additions.additionKeys) {
            if (newAdditions.contains(addition)) continue;
            newAdditions.add(addition);
        }
        return new MaterialAdditions(newAdditions);
    }

    public boolean matches(ResourceLocation key) {
        for (ResourceLocation additionKey : this.additionKeys) {
            if (!key.equals((Object)additionKey)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.additionKeys.isEmpty();
    }

    public ResourceLocation apply(ResourceLocation id) {
        if (this.additionKeys.isEmpty()) {
            return id;
        }
        String additionPrefix = "/additions/";
        String path = id.getPath();
        int index = path.indexOf(additionPrefix);
        StringBuilder newPath = index != -1 ? new StringBuilder(path.substring(0, index + additionPrefix.length())) : new StringBuilder(path + additionPrefix);
        for (ResourceLocation additionKey : this.additionKeys) {
            newPath.append(additionKey.getNamespace()).append("/").append(additionKey.getPath()).append("/");
        }
        return id.withPath(newPath.toString());
    }

    public static int removeMaterials(ItemStack stack, int count) {
        if (!enableMaterialAdditions) {
            return count;
        }
        MaterialAdditions additions = (MaterialAdditions)stack.getOrDefault(TYPE, (Object)NONE);
        if (additions.isEmpty()) {
            return count;
        }
        ArrayList<ResourceLocation> newAdditions = new ArrayList<ResourceLocation>(additions.additionKeys);
        while (count > 0 && !newAdditions.isEmpty()) {
            newAdditions.removeLast();
            --count;
        }
        if (newAdditions.isEmpty()) {
            stack.remove(TYPE);
        } else {
            stack.set(TYPE, (Object)new MaterialAdditions(newAdditions));
        }
        return count;
    }

    static {
        CODEC = ResourceLocation.CODEC.listOf().xmap(list -> new MaterialAdditions(List.copyOf(list)), materialAddition -> materialAddition == null ? List.of() : List.copyOf(materialAddition.additionKeys));
        STREAM_CODEC = ByteBufCodecs.list().apply(ResourceLocation.STREAM_CODEC).map(list -> new MaterialAdditions(List.copyOf(list)), materialAddition -> materialAddition == null ? List.of() : List.copyOf(materialAddition.additionKeys));
    }
}

