/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.mixin.render;

import com.bawnorton.trimica.client.TrimicaClient;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import net.minecraft.client.gui.render.GuiRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiRenderer.class})
abstract class GuiRendererMixin {
    GuiRendererMixin() {
    }

    @Shadow
    protected abstract void invalidateItemAtlas();

    @Shadow
    protected abstract int getGuiScaleInvalidatingItemAtlasIfChanged();

    @Shadow
    protected abstract int calculateAtlasSizeInPixels(int var1);

    @Shadow
    protected abstract void createAtlasTextures(int var1);

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void resetUVs(GpuBufferSlice fogUniforms, CallbackInfo ci) {
        if (TrimicaClient.getRuntimeAtlases().shouldResetUVs()) {
            TrimicaClient.getRuntimeAtlases().setShouldResetUVs(false);
            this.invalidateItemAtlas();
            int guiScale = this.getGuiScaleInvalidatingItemAtlasIfChanged();
            int itemWidth = 16 * guiScale;
            int atlasSize = this.calculateAtlasSizeInPixels(itemWidth);
            this.createAtlasTextures(atlasSize);
        }
    }
}

