/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.client.mixin.accessor.AtlasManager$PendingStitchResultsAccessor;
import com.bawnorton.trimica.client.mixin.accessor.SpriteContents$TickerAccessor;
import com.bawnorton.trimica.client.mixin.accessor.SpriteLoaderAccessor;
import com.bawnorton.trimica.client.mixin.accessor.TextureAtlasAccessor;
import com.bawnorton.trimica.client.mixin.accessor.TextureAtlasSprite$TickerAccessor;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.AbstractTrimSpriteFactory;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlases;
import com.bawnorton.trimica.client.texture.TrimSpriteContents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.SpriteTicker;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.AtlasManager;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.jetbrains.annotations.NotNull;

public final class RuntimeTrimAtlas
extends TextureAtlas {
    private final AbstractTrimSpriteFactory spriteFactory;
    private final RuntimeTrimAtlases.TrimFactory trimFactory;
    private final RenderType renderType;
    private final List<SpriteContents> dynamicSprites = new ArrayList<SpriteContents>();
    private final Map<ResourceLocation, TrimPalette> palettes = new HashMap<ResourceLocation, TrimPalette>();
    private final Consumer<RuntimeTrimAtlas> onModified;
    private final AtlasManager.AtlasEntry atlasEntry;

    public RuntimeTrimAtlas(ResourceLocation atlasLocation, AbstractTrimSpriteFactory spriteFactory, RuntimeTrimAtlases.TrimFactory trimFactory, Consumer<RuntimeTrimAtlas> onModified) {
        super(atlasLocation);
        this.spriteFactory = spriteFactory;
        this.trimFactory = trimFactory;
        this.renderType = RenderType.armorCutoutNoCull((ResourceLocation)atlasLocation);
        this.dynamicSprites.add(this.createMissing());
        this.onModified = onModified;
        AtlasManager.AtlasConfig atlasConfig = new AtlasManager.AtlasConfig(atlasLocation, Trimica.rl("generated"), false);
        this.atlasEntry = new AtlasManager.AtlasEntry((TextureAtlas)this, atlasConfig);
    }

    private SpriteContents createMissing() {
        ResourceLocation missingLocation = MissingTextureAtlasSprite.getLocation();
        return this.spriteFactory.create(missingLocation, null, null).spriteContents();
    }

    @NotNull
    public TextureAtlasSprite getSprite(@NotNull ResourceLocation texture) {
        throw new UnsupportedOperationException("Use getSprite(DataComponentGetter, TrimMaterial, ResourceLocation) instead");
    }

    @NotNull
    public DynamicTrimTextureAtlasSprite getSprite(DataComponentGetter componentGetter, TrimPattern pattern, ResourceLocation texture) {
        Map<ResourceLocation, TextureAtlasSprite> texturesByName = this.asAccessor().trimica$texturesByName();
        TextureAtlasSprite sprite = texturesByName.get(texture);
        if (sprite == null) {
            sprite = this.createSprite(componentGetter, pattern, texture);
        }
        return new DynamicTrimTextureAtlasSprite(sprite, this.renderType, this.palettes.get(texture));
    }

    private DynamicTrimTextureAtlasSprite createSprite(DataComponentGetter componentGetter, TrimPattern pattern, ResourceLocation texture) {
        TrimSpriteContents sprite = this.spriteFactory.create(texture, this.trimFactory.create(pattern), componentGetter);
        this.dynamicSprites.add(sprite.spriteContents());
        this.stitchAndUpload();
        this.onModified.accept(this);
        Minecraft client = Minecraft.getInstance();
        client.getTextureManager().register(this.location(), (AbstractTexture)this);
        this.palettes.put(texture, sprite.palette());
        return new DynamicTrimTextureAtlasSprite(this.asAccessor().trimica$texturesByName().get(texture), this.renderType, sprite.palette());
    }

    private void stitchAndUpload() {
        ArrayList<AtlasManager.PendingStitch> pendingStitches = new ArrayList<AtlasManager.PendingStitch>();
        HashMap<ResourceLocation, CompletableFuture<SpriteLoader.Preparations>> stitchFutureById = new HashMap<ResourceLocation, CompletableFuture<SpriteLoader.Preparations>>();
        ArrayList<CompletionStage> allReadyToUpload = new ArrayList<CompletionStage>();
        CompletableFuture preparations = new CompletableFuture();
        stitchFutureById.put(this.location(), preparations);
        pendingStitches.add(new AtlasManager.PendingStitch(this.atlasEntry, preparations));
        allReadyToUpload.add(preparations.thenCompose(SpriteLoader.Preparations::readyForUpload));
        AtlasManager$PendingStitchResultsAccessor pendingStitchResults = (AtlasManager$PendingStitchResultsAccessor)AtlasManager$PendingStitchResultsAccessor.trimica$init(pendingStitches, stitchFutureById, CompletableFuture.allOf(allReadyToUpload.toArray(new CompletableFuture[0])));
        SpriteLoaderAccessor loader = (SpriteLoaderAccessor)SpriteLoader.create((TextureAtlas)this);
        pendingStitchResults.trimica$pendingStitches().forEach(stitch -> {
            SpriteLoader.Preparations stitched = loader.trimica$stitch(this.dynamicSprites, 0, (Executor)Util.backgroundExecutor());
            if (stitched != null) {
                stitch.preparations().complete(stitched);
            } else {
                stitch.preparations().completeExceptionally(new RuntimeException("Failed to stitch dynamic trim atlas"));
            }
        });
        ((CompletableFuture)pendingStitchResults.trimica$allReadyToUpload().thenApply(o -> ((AtlasManager.PendingStitchResults)pendingStitchResults).joinAndUpload())).join();
    }

    public void clearTextureData() {
        TextureAtlasAccessor accessor = this.asAccessor();
        accessor.trimica$sprites(List.of());
        accessor.trimica$animatedTextures(List.of());
        accessor.trimica$texturesByName(Map.of());
        accessor.trimica$missingSprite(null);
    }

    public void resetFrames() {
        List<TextureAtlasSprite.Ticker> tickers = this.asAccessor().trimica$animatedTextures();
        for (TextureAtlasSprite.Ticker ticker : tickers) {
            TextureAtlasSprite$TickerAccessor accessor;
            SpriteTicker spriteTicker;
            if (!(ticker instanceof TextureAtlasSprite$TickerAccessor) || !((spriteTicker = (accessor = (TextureAtlasSprite$TickerAccessor)ticker).trimica$ticker()) instanceof SpriteContents$TickerAccessor)) continue;
            SpriteContents$TickerAccessor spriteTicker2 = (SpriteContents$TickerAccessor)spriteTicker;
            spriteTicker2.trimica$frame(0);
        }
    }

    private TextureAtlasAccessor asAccessor() {
        return (TextureAtlasAccessor)((Object)this);
    }

    public void clear() {
        this.spriteFactory.clear();
        this.dynamicSprites.clear();
        this.dynamicSprites.add(this.createMissing());
        this.clearTextureData();
    }
}

