/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.model.TrimModelId;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlas;
import com.bawnorton.trimica.client.texture.TrimArmourSpriteFactory;
import com.bawnorton.trimica.client.texture.TrimItemSpriteFactory;
import com.bawnorton.trimica.client.texture.TrimShieldSpriteFactory;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.trim.TrimmedType;
import com.bawnorton.trimica.util.Lazy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;

public final class RuntimeTrimAtlases {
    private final Map<TrimMaterial, Map<EquipmentClientInfo.LayerType, Lazy<RuntimeTrimAtlas>>> equipmentAtlases = new HashMap<TrimMaterial, Map<EquipmentClientInfo.LayerType, Lazy<RuntimeTrimAtlas>>>();
    private final Map<TrimMaterial, Lazy<RuntimeTrimAtlas>> itemAtlases = new HashMap<TrimMaterial, Lazy<RuntimeTrimAtlas>>();
    private final Map<TrimMaterial, Lazy<RuntimeTrimAtlas>> shieldAtlases = new HashMap<TrimMaterial, Lazy<RuntimeTrimAtlas>>();
    private final List<Consumer<RuntimeTrimAtlas>> modelAtlasModifiedListeners = new ArrayList<Consumer<RuntimeTrimAtlas>>();
    private boolean shouldResetUVs = false;

    public void init(RegistryAccess registryAccess) {
        this.equipmentAtlases.values().forEach(Map::clear);
        this.equipmentAtlases.clear();
        this.itemAtlases.clear();
        this.shieldAtlases.clear();
        Registry materials = (Registry)registryAccess.lookup(Registries.TRIM_MATERIAL).orElseThrow();
        for (TrimMaterial material : materials) {
            for (EquipmentClientInfo.LayerType layerType : EquipmentClientInfo.LayerType.values()) {
                this.createEquipmentAtlas(registryAccess, material, layerType);
            }
            this.createItemAtlas(registryAccess, material);
            this.createShieldAtlas(registryAccess, material);
        }
    }

    private void resetFrames() {
        for (Map<EquipmentClientInfo.LayerType, Lazy<RuntimeTrimAtlas>> layerBasedAtlases : this.equipmentAtlases.values()) {
            for (Lazy<RuntimeTrimAtlas> atlas : layerBasedAtlases.values()) {
                if (!atlas.isPresent()) continue;
                atlas.get().resetFrames();
            }
        }
    }

    private Lazy<RuntimeTrimAtlas> createEquipmentAtlas(RegistryAccess registryAccess, TrimMaterial material, EquipmentClientInfo.LayerType layerType) {
        Registry materials = (Registry)registryAccess.lookup(Registries.TRIM_MATERIAL).orElseThrow();
        Registry patterns = (Registry)registryAccess.lookup(Registries.TRIM_PATTERN).orElseThrow();
        String materialId = Trimica.getMaterialRegistry().getSuffix(material);
        return new Lazy<RuntimeTrimAtlas>(() -> new RuntimeTrimAtlas(Trimica.rl("%s/%s.png".formatted(materialId, layerType.getSerializedName())), new TrimArmourSpriteFactory(layerType), p -> new ArmorTrim(materials.wrapAsHolder((Object)material), patterns.wrapAsHolder((Object)p)), atlas -> {
            this.resetFrames();
            for (Consumer<RuntimeTrimAtlas> listener : this.modelAtlasModifiedListeners) {
                listener.accept((RuntimeTrimAtlas)((Object)((Object)atlas)));
            }
        }));
    }

    private Lazy<RuntimeTrimAtlas> createItemAtlas(RegistryAccess registryAccess, TrimMaterial material) {
        Registry materials = (Registry)registryAccess.lookup(Registries.TRIM_MATERIAL).orElseThrow();
        Registry patterns = (Registry)registryAccess.lookup(Registries.TRIM_PATTERN).orElseThrow();
        String materialId = Trimica.getMaterialRegistry().getSuffix(material);
        return new Lazy<RuntimeTrimAtlas>(() -> new RuntimeTrimAtlas(Trimica.rl("%s/item.png".formatted(materialId)), new TrimItemSpriteFactory(), p -> new ArmorTrim(materials.wrapAsHolder((Object)material), patterns.wrapAsHolder((Object)p)), atlas -> {
            TrimicaClient.getItemModelFactory().clearModels();
            for (Consumer<RuntimeTrimAtlas> listener : this.modelAtlasModifiedListeners) {
                listener.accept((RuntimeTrimAtlas)((Object)((Object)atlas)));
            }
        }));
    }

    private Lazy<RuntimeTrimAtlas> createShieldAtlas(RegistryAccess registryAccess, TrimMaterial material) {
        Registry materials = (Registry)registryAccess.lookup(Registries.TRIM_MATERIAL).orElseThrow();
        Registry patterns = (Registry)registryAccess.lookup(Registries.TRIM_PATTERN).orElseThrow();
        String materialId = Trimica.getMaterialRegistry().getSuffix(material);
        return new Lazy<RuntimeTrimAtlas>(() -> new RuntimeTrimAtlas(Trimica.rl("%s/shield.png".formatted(materialId)), new TrimShieldSpriteFactory(), p -> new ArmorTrim(materials.wrapAsHolder((Object)material), patterns.wrapAsHolder((Object)p)), atlas -> {
            for (Consumer<RuntimeTrimAtlas> listener : this.modelAtlasModifiedListeners) {
                listener.accept((RuntimeTrimAtlas)((Object)((Object)atlas)));
            }
        }));
    }

    public RuntimeTrimAtlas getEquipmentAtlas(ClientLevel level, TrimMaterial material, EquipmentClientInfo.LayerType layerType) {
        return (RuntimeTrimAtlas)((Object)this.equipmentAtlases.computeIfAbsent(material, k -> new HashMap()).computeIfAbsent(layerType, k -> this.createEquipmentAtlas(level.registryAccess(), material, layerType)).get());
    }

    public RuntimeTrimAtlas getItemAtlas(ClientLevel level, TrimMaterial material) {
        return (RuntimeTrimAtlas)((Object)this.itemAtlases.computeIfAbsent(material, k -> this.createItemAtlas(level.registryAccess(), (TrimMaterial)k)).get());
    }

    public RuntimeTrimAtlas getShieldAtlas(ClientLevel level, TrimMaterial material) {
        return (RuntimeTrimAtlas)((Object)this.shieldAtlases.computeIfAbsent(material, k -> this.createShieldAtlas(level.registryAccess(), (TrimMaterial)k)).get());
    }

    public List<DynamicTrimTextureAtlasSprite> getShieldSprites(ClientLevel level, DataComponentGetter getter) {
        ArrayList<DynamicTrimTextureAtlasSprite> sprites = new ArrayList<DynamicTrimTextureAtlasSprite>();
        List<ArmorTrim> trims = AdditionalTrims.getAllTrims(getter);
        for (ArmorTrim trim : trims) {
            TrimModelId trimModelId = TrimModelId.fromTrim(TrimmedType.SHIELD, trim, null);
            ResourceLocation overlayLocation = trimModelId.asSingle();
            if (MaterialAdditions.enableMaterialAdditions) {
                MaterialAdditions addition = (MaterialAdditions)getter.getOrDefault(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
                overlayLocation = addition.apply(overlayLocation);
            }
            sprites.add(this.getShieldAtlas(level, (TrimMaterial)trim.material().value()).getSprite(getter, (TrimPattern)trim.pattern().value(), overlayLocation));
        }
        return sprites;
    }

    public void addModelAtlasModifiedListener(Consumer<RuntimeTrimAtlas> listener) {
        this.modelAtlasModifiedListeners.add(listener);
    }

    public boolean shouldResetUVs() {
        return this.shouldResetUVs;
    }

    public void setShouldResetUVs(boolean shouldResetUVs) {
        this.shouldResetUVs = shouldResetUVs;
    }

    public void clear() {
        this.equipmentAtlases.forEach((pattern, lazyMap) -> lazyMap.forEach((layer, lazy) -> lazy.ifPresent(RuntimeTrimAtlas::clear)));
        this.itemAtlases.forEach((pattern, lazy) -> lazy.ifPresent(RuntimeTrimAtlas::clear));
        this.shieldAtlases.forEach((pattern, lazy) -> lazy.ifPresent(RuntimeTrimAtlas::clear));
        this.equipmentAtlases.clear();
        this.itemAtlases.clear();
        this.shieldAtlases.clear();
    }

    public static interface TrimFactory {
        public ArmorTrim create(TrimPattern var1);
    }
}

