/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.data.provider;

import com.bawnorton.trimica.data.recipe.MaterialAdditionRecipeBuilder;
import com.bawnorton.trimica.data.tags.ConventionalTags;
import com.bawnorton.trimica.data.tags.TrimicaTags;
import com.bawnorton.trimica.item.TrimicaItems;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public interface TrimicaRecipeProvider {
    default public void buildRecipes(RecipeOutput output) {
        this.materialAdditionRecipe(output, TrimicaTags.ALL_TRIMMABLES, TrimicaTags.MATERIAL_ADDITIONS);
        this.shaped(RecipeCategory.MISC, TrimicaItems.RAINBOWIFIER, 1).define(Character.valueOf('R'), ConventionalTags.RED_DYES).define(Character.valueOf('O'), ConventionalTags.ORANGE_DYES).define(Character.valueOf('Y'), ConventionalTags.YELLOW_DYES).define(Character.valueOf('G'), ConventionalTags.LIME_DYES).define(Character.valueOf('C'), ConventionalTags.CYAN_DYES).define(Character.valueOf('B'), ConventionalTags.BLUE_DYES).define(Character.valueOf('I'), ConventionalTags.PURPLE_DYES).define(Character.valueOf('V'), ConventionalTags.PINK_DYES).define(Character.valueOf('X'), (ItemLike)TrimicaItems.ANIMATOR).pattern("ROY").pattern("VXG").pattern("IBC").unlockedBy("has_ingredients", this.has(ConventionalTags.DYES)).save(output);
    }

    default public void materialAdditionRecipe(RecipeOutput output, TagKey<Item> baseTag, TagKey<Item> additionTag) {
        MaterialAdditionRecipeBuilder.materialAddition(RecipeCategory.MISC, this.tag(baseTag), this.tag(additionTag)).unlocks("has_ingredients", this.has(additionTag)).save(output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)additionTag.location()));
    }

    public ShapedRecipeBuilder shaped(RecipeCategory var1, Item var2, int var3);

    public Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> var1);

    public Ingredient tag(TagKey<Item> var1);
}

