/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.loot;

import com.bawnorton.trimica.mixin.accessor.CompositeEntryBaseAccessor;
import com.bawnorton.trimica.mixin.accessor.DynamicLootAccessor;
import com.bawnorton.trimica.mixin.accessor.LootItemAccessor;
import com.bawnorton.trimica.mixin.accessor.LootPoolAccessor;
import com.bawnorton.trimica.mixin.accessor.LootTableAccessor;
import com.bawnorton.trimica.mixin.accessor.NestedLootTableAccessor;
import com.bawnorton.trimica.mixin.accessor.TagEntryAccessor;
import com.mojang.datafixers.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;

public class LootTableReader {
    public static List<Item> read(LootTableGetter getter, LootTable lootTable) {
        LootTableAccessor accessor = (LootTableAccessor)lootTable;
        List<LootPool> pools = accessor.trimica$pools();
        ArrayList<Item> items = new ArrayList<Item>();
        for (LootPool pool : pools) {
            List<LootPoolEntryContainer> entries = ((LootPoolAccessor)pool).trimica$entries();
            for (LootPoolEntryContainer entry : entries) {
                items.addAll(LootTableReader.readEntry(getter, entry));
            }
        }
        return items;
    }

    private static List<Item> readEntry(LootTableGetter getter, LootPoolEntryContainer entry) {
        LootPoolEntryContainer lootPoolEntryContainer = entry;
        Objects.requireNonNull(lootPoolEntryContainer);
        LootPoolEntryContainer lootPoolEntryContainer2 = lootPoolEntryContainer;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompositeEntryBaseAccessor.class, LootPoolSingletonContainer.class}, (Object)lootPoolEntryContainer2, n)) {
            case 0 -> {
                CompositeEntryBaseAccessor compositeEntryBase = (CompositeEntryBaseAccessor)lootPoolEntryContainer2;
                ArrayList<Item> items = new ArrayList<Item>();
                for (LootPoolEntryContainer lootPoolEntry : compositeEntryBase.trimica$children()) {
                    items.addAll(LootTableReader.readEntry(getter, lootPoolEntry));
                }
                yield items;
            }
            case 1 -> {
                LootPoolSingletonContainer singletonContainer;
                LootPoolSingletonContainer v2 = singletonContainer = (LootPoolSingletonContainer)lootPoolEntryContainer2;
                Objects.requireNonNull(v2);
                LootPoolSingletonContainer var10_11 = v2;
                int var11_12 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DynamicLootAccessor.class, LootItemAccessor.class, NestedLootTableAccessor.class, TagEntryAccessor.class}, (Object)var10_11, var11_12)) {
                    case 0: {
                        DynamicLootAccessor dynamicLoot = (DynamicLootAccessor)var10_11;
                        ResourceLocation name = dynamicLoot.trimica$name();
                        if (name.equals((Object)DecoratedPotBlock.SHERDS_DYNAMIC_DROP_ID)) {
                            yield List.of(Items.DECORATED_POT);
                        }
                        if (name.equals((Object)ShulkerBoxBlock.CONTENTS)) {
                            yield List.of(Items.SHULKER_BOX);
                        }
                        yield List.of();
                    }
                    case 1: {
                        LootItemAccessor lootItem = (LootItemAccessor)var10_11;
                        yield List.of((Item)lootItem.trimica$item().value());
                    }
                    case 2: {
                        NestedLootTableAccessor nestedLootTable = (NestedLootTableAccessor)var10_11;
                        Either<ResourceKey<LootTable>, LootTable> value = nestedLootTable.trimica$contents();
                        LootTable table = (LootTable)value.map(key -> getter.get(key.location()), Function.identity());
                        if (table == null) {
                            yield List.of();
                        }
                        yield LootTableReader.read(getter, table);
                    }
                    case 3: {
                        TagEntryAccessor tagEntry = (TagEntryAccessor)var10_11;
                        TagKey<Item> tagKey = tagEntry.trimica$tag();
                        ArrayList<Item> items = new ArrayList<Item>();
                        BuiltInRegistries.ITEM.get(tagKey).ifPresent(named -> named.forEach(holder -> items.add((Item)holder.value())));
                        yield items;
                    }
                }
                yield List.of();
            }
            default -> List.of();
        };
    }

    public static interface LootTableGetter {
        public LootTable get(ResourceLocation var1);
    }
}

