/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.mixin.loot;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.TrimicaToggles;
import com.bawnorton.trimica.item.TrimicaItems;
import com.bawnorton.trimica.loot.LootTableReader;
import com.bawnorton.trimica.mixin.accessor.LootTable$BuilderAccessor;
import com.bawnorton.trimica.mixin.accessor.LootTableAccessor;
import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ReloadableServerRegistries.class})
abstract class ReloadableServerRegistriesMixin {
    ReloadableServerRegistriesMixin() {
    }

    @ModifyReceiver(method={"lambda$scheduleRegistryLoad$5"}, at={@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V")})
    private static <T> Map<ResourceLocation, T> modifyLootTables(Map<ResourceLocation, T> instance, BiConsumer<ResourceLocation, T> consumer) {
        if (!TrimicaToggles.enableItems || !TrimicaToggles.enableAnimator) {
            return instance;
        }
        int counter = 0;
        for (Map.Entry<ResourceLocation, T> entry : instance.entrySet()) {
            LootTable lootTable;
            List<Item> items;
            boolean containsTemplateItem;
            T value = entry.getValue();
            if (!(value instanceof LootTable) || !(containsTemplateItem = (items = LootTableReader.read(rl -> (LootTable)instance.get(rl), lootTable = (LootTable)value)).stream().anyMatch(item -> item instanceof SmithingTemplateItem))) continue;
            LootTable.Builder builder = new LootTable.Builder();
            LootTableAccessor accessor = (LootTableAccessor)lootTable;
            LootTable$BuilderAccessor builderAccessor = (LootTable$BuilderAccessor)builder;
            builder.setParamSet(lootTable.getParamSet());
            builderAccessor.trimica$pools((ImmutableList.Builder<LootPool>)ImmutableList.builder().addAll(accessor.trimica$pools()));
            builderAccessor.trimica$functions((ImmutableList.Builder<LootItemFunction>)ImmutableList.builder().addAll(accessor.trimica$functions()));
            accessor.trimica$randomSequence().ifPresent(arg_0 -> ((LootTable.Builder)builder).setRandomSequence(arg_0));
            builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)TrimicaItems.ANIMATOR)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(15)));
            instance.put(entry.getKey(), builder.build());
            ++counter;
        }
        if (counter > 0) {
            Trimica.LOGGER.info("Added Trimica's Animator to {} loot tables", (Object)counter);
        }
        return instance;
    }
}

