/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.colour;

import com.bawnorton.trimica.client.colour.ColourHSB;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ColourGroup
implements Comparable<ColourGroup> {
    private final ColourHSB representative;
    private final List<ColourHSB> colours;

    public ColourGroup(ColourHSB representative) {
        this.representative = representative;
        this.colours = new ArrayList<ColourHSB>();
        this.colours.add(representative);
    }

    public ColourHSB getRepresentative() {
        return this.representative;
    }

    public void addMember(ColourHSB colour) {
        this.colours.add(colour);
    }

    public int getWeight() {
        return this.colours.size();
    }

    public boolean isSimilar(ColourHSB colour) {
        boolean saturationSimilar = Math.abs(colour.saturation() - this.representative.saturation()) < 0.1f;
        boolean brightnessSimilar = Math.abs(colour.brightness() - this.representative.brightness()) < 0.1f;
        boolean hueSimilar = Math.abs(colour.hue() - this.representative.hue()) < 0.1f;
        return saturationSimilar && brightnessSimilar && hueSimilar;
    }

    @Override
    public int compareTo(@NotNull ColourGroup o) {
        return Integer.compare(this.getWeight(), o.getWeight());
    }

    public String toString() {
        return "ColourGroup[%s, (%d)]".formatted(this.representative, this.colours.size());
    }
}

