/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.palette;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.client.colour.ColourGroup;
import com.bawnorton.trimica.client.colour.ColourHSB;
import com.bawnorton.trimica.client.colour.OkLabHelper;
import com.bawnorton.trimica.client.mixin.accessor.BlockModelWrapperAccessor;
import com.bawnorton.trimica.client.mixin.accessor.CompositeModelAccessor;
import com.bawnorton.trimica.client.mixin.accessor.ConditionalItemModelAccessor;
import com.bawnorton.trimica.client.mixin.accessor.ItemModelResolverAccessor;
import com.bawnorton.trimica.client.mixin.accessor.RangeSelectItemModelAccessor;
import com.bawnorton.trimica.client.mixin.accessor.SelectItemModelAccessor;
import com.bawnorton.trimica.client.mixin.accessor.SpecialModelWrapperAccessor;
import com.bawnorton.trimica.client.mixin.accessor.SpriteContentsAccessor;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_10394;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10447;
import net.minecraft.class_10539;
import net.minecraft.class_1058;
import net.minecraft.class_10809;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

public final class TrimPaletteGenerator {
    private static final Map<class_8054, TrimPalette> TRIM_PALETTES = new HashMap<class_8054, TrimPalette>();
    private static final Map<class_8054, TrimPalette> BUILT_IN_PALETTES = new HashMap<class_8054, TrimPalette>();

    @NotNull
    public TrimPalette generatePalette(class_8054 material, class_5321<class_10394> assetKey) {
        class_1792 materialProvider = Trimica.getMaterialRegistry().guessMaterialProvider(material);
        if (materialProvider == null) {
            return this.generatePaletteFromBuiltIn(material, assetKey);
        }
        if (!TrimMaterialRuntimeRegistry.enableTrimEverything) {
            Trimica.LOGGER.warn("Trim palette generation is disabled, cannot generate palette for material: {}", (Object)class_7923.field_41178.method_10221((Object)materialProvider));
            return TrimPalette.DISABLED;
        }
        class_10442 modelResolver = class_310.method_1551().method_65386();
        class_10439 model = ((ItemModelResolverAccessor)modelResolver).trimica$modelGetter().apply(class_7923.field_41178.method_10221((Object)materialProvider));
        return this.generatePaletteFromModel(material, assetKey, model);
    }

    @NotNull
    private TrimPalette generatePaletteFromBuiltIn(class_8054 material, class_5321<class_10394> assetKey) {
        return BUILT_IN_PALETTES.computeIfAbsent(material, k -> {
            List<Integer> colours = this.getColoursFromBuiltIn(material, assetKey);
            if (colours.isEmpty()) {
                return TrimPalette.MISSING;
            }
            return new TrimPalette(colours, true);
        });
    }

    private List<Integer> getColoursFromBuiltIn(class_8054 material, class_5321<class_10394> assetKey) {
        List<Integer> list;
        block11: {
            class_310 minecraft = class_310.method_1551();
            class_3300 resourceManager = minecraft.method_1478();
            class_638 level = minecraft.field_1687;
            if (level == null) {
                return List.of();
            }
            class_2378 lookup = level.method_30349().method_46759(class_7924.field_42083).orElse(null);
            if (lookup == null) {
                return List.of();
            }
            class_2960 materialId = lookup.method_10221((Object)material);
            if (materialId == null && (materialId = (class_2960)lookup.method_29722().stream().filter(e -> ((class_8054)e.getValue()).equals((Object)material)).findFirst().map(Map.Entry::getKey).map(class_5321::method_29177).orElse(null)) == null) {
                return List.of();
            }
            String suffix = Trimica.getMaterialRegistry().getSuffix(material, assetKey);
            class_10539 contents = class_10539.method_65871((class_3300)resourceManager, (class_2960)materialId.method_45136("textures/trims/color_palettes/%s.png".formatted(suffix)));
            try {
                class_1011 image = contents.comp_3447();
                list = this.extractColoursFromBuiltIn(image);
                if (contents == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    Trimica.LOGGER.error("Failed to load trim palette texture", (Throwable)e2);
                    return List.of();
                }
            }
            contents.close();
        }
        return list;
    }

    private List<Integer> extractColoursFromBuiltIn(class_1011 builtInImage) {
        int width = builtInImage.method_4307();
        int height = builtInImage.method_4323();
        if (width != 8 || height != 1) {
            return List.of();
        }
        ArrayList<Integer> colours = new ArrayList<Integer>(8);
        for (int x = 0; x < width; ++x) {
            int colour = builtInImage.method_61940(x, 0);
            colours.add(colour);
        }
        return colours;
    }

    private TrimPalette generatePaletteFromModel(class_8054 material, class_5321<class_10394> assetKey, class_10439 model) {
        return TRIM_PALETTES.computeIfAbsent(material, key -> {
            List<Integer> colours = this.getColoursFromModel(model);
            if (colours.isEmpty()) {
                Trimica.LOGGER.warn("Trim palette colour could of determined for {}", (Object)Trimica.getMaterialRegistry().getSuffix(material, assetKey));
                return TrimPalette.DEFAULT;
            }
            colours = this.getDominantColours(colours);
            colours = this.sortPalette(colours);
            colours = this.stretchPalette(colours);
            return new TrimPalette(colours);
        });
    }

    private List<Integer> getColoursFromModel(class_10439 model) {
        class_10439 class_104392 = model;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockModelWrapperAccessor.class, SelectItemModelAccessor.class, SpecialModelWrapperAccessor.class, CompositeModelAccessor.class, ConditionalItemModelAccessor.class, RangeSelectItemModelAccessor.class}, (Object)class_104392, n)) {
            case 0 -> {
                BlockModelWrapperAccessor blockModelWrapperAccessor = (BlockModelWrapperAccessor)class_104392;
                yield this.getColoursFromQuads(blockModelWrapperAccessor.trimica$quads());
            }
            case 1 -> {
                SelectItemModelAccessor selectItemModelAccessor = (SelectItemModelAccessor)class_104392;
                yield this.getColoursFromModel(selectItemModelAccessor.trimica$models().get(null, null));
            }
            case 2 -> {
                SpecialModelWrapperAccessor specialModelWrapperAccessor = (SpecialModelWrapperAccessor)class_104392;
                class_10809 properties = specialModelWrapperAccessor.trimica$properties();
                int[] colours = this.extractColours(properties.comp_3767());
                yield Arrays.stream(colours).boxed().toList();
            }
            case 3 -> {
                CompositeModelAccessor compositeModelAccessor = (CompositeModelAccessor)class_104392;
                yield this.getColoursFromModel(compositeModelAccessor.trimica$models().getFirst());
            }
            case 4 -> {
                ConditionalItemModelAccessor conditionalItemModelAccessor = (ConditionalItemModelAccessor)class_104392;
                yield this.getColoursFromModel(conditionalItemModelAccessor.trimica$onFalse());
            }
            case 5 -> {
                RangeSelectItemModelAccessor rangeSelectItemModelAccessor = (RangeSelectItemModelAccessor)class_104392;
                class_10439 fallback = rangeSelectItemModelAccessor.trimica$fallback();
                if (!(fallback instanceof class_10447)) {
                    yield this.getColoursFromModel(fallback);
                }
                class_10439[] models = rangeSelectItemModelAccessor.trimica$models();
                if (models.length > 0) {
                    yield this.getColoursFromModel(models[0]);
                }
                yield Collections.emptyList();
            }
            case -1 -> Collections.emptyList();
            default -> {
                Trimica.LOGGER.warn("Cannot extract colours from unknown item model type: {}", (Object)model.getClass().getName());
                yield Collections.emptyList();
            }
        };
    }

    private List<Integer> getDominantColours(List<Integer> colours) {
        List<ColourHSB> hsbColours = ColourHSB.fromARGB(colours);
        ArrayList<ColourGroup> groups = new ArrayList<ColourGroup>();
        for (ColourHSB colour : hsbColours) {
            boolean foundGroup = false;
            for (ColourGroup group : groups) {
                if (!group.isSimilar(colour)) continue;
                group.addMember(colour);
                foundGroup = true;
                break;
            }
            if (foundGroup) continue;
            groups.add(new ColourGroup(colour));
        }
        Collections.sort(groups);
        ArrayList<ColourHSB> dominantColours = new ArrayList<ColourHSB>();
        int count = 0;
        for (ColourGroup group : groups) {
            if (count >= 8) break;
            dominantColours.add(group.getRepresentative());
            ++count;
        }
        ArrayList<Integer> dominantRGB = new ArrayList<Integer>();
        for (ColourHSB colour : dominantColours) {
            dominantRGB.add(colour.rgb());
        }
        return dominantRGB;
    }

    private List<Integer> sortPalette(List<Integer> colours) {
        return ColourHSB.fromARGB(colours).stream().sorted().map(ColourHSB::rgb).toList();
    }

    private List<Integer> stretchPalette(List<Integer> palette) {
        int targetSize;
        int size = palette.size();
        if (size >= (targetSize = 8)) {
            return palette;
        }
        List<double[]> oklabPalette = OkLabHelper.rgbToOklab(palette);
        List<double[]> stretchedOKLab = OkLabHelper.strechOkLab(targetSize, size, oklabPalette);
        return OkLabHelper.okLabToRgb(stretchedOKLab);
    }

    @NotNull
    private List<Integer> getColoursFromQuads(List<class_777> quads) {
        ArrayList<Integer> colours = new ArrayList<Integer>(quads.size() * 16 * 16);
        for (class_777 bakedQuad : quads) {
            int[] colourData;
            for (int colour : colourData = this.extractColours(bakedQuad.comp_3724())) {
                colours.add(colour);
            }
        }
        return colours.stream().filter(i -> i != 0).toList();
    }

    private int[] extractColours(class_1058 sprite) {
        class_1011 spriteImage = ((SpriteContentsAccessor)sprite.method_45851()).trimica$originalImage();
        int width = spriteImage.method_4307();
        int height = spriteImage.method_4323();
        int[] colourData = new int[width * height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int packed;
                int argb = spriteImage.method_61940(x, y);
                int alpha = class_9848.method_61320((int)argb);
                if (alpha == 0) continue;
                int red = class_9848.method_61327((int)argb);
                int green = class_9848.method_61329((int)argb);
                int blue = class_9848.method_61331((int)argb);
                colourData[x + y * width] = packed = red << 16 | green << 8 | blue;
            }
        }
        return colourData;
    }

    public void clear() {
        TRIM_PALETTES.clear();
        BUILT_IN_PALETTES.clear();
    }
}

