/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.client.palette.AnimatedTrimPalette;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.TrimSpriteContents;
import com.bawnorton.trimica.client.texture.TrimSpriteMetadata;
import com.bawnorton.trimica.platform.Platform;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_10539;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_7368;
import net.minecraft.class_7677;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import net.minecraft.class_8053;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTrimSpriteFactory {
    static final Map<class_2960, class_10539> textureCache = new HashMap<class_2960, class_10539>();
    protected final int width;
    protected final int height;

    protected AbstractTrimSpriteFactory(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public TrimSpriteContents create(class_2960 texture, @Nullable class_8053 trim, @Nullable class_9473 componentGetter) {
        if (trim == null) {
            return TrimSpriteContents.noPalette(new class_7764(texture, new class_7771(this.width, this.height), this.empty()));
        }
        TrimSpriteMetadata metadata = this.getSpriteMetadata(trim, componentGetter, texture);
        if (metadata == null) {
            return TrimSpriteContents.noPalette(new class_7764(texture, new class_7771(this.width, this.height), this.empty()));
        }
        class_1011 image = this.createImageFromMetadata(metadata);
        class_7368 resourceMetadata = this.getResourceMetadataFromSpriteMetadata(metadata);
        return new TrimSpriteContents(new class_7764(texture, new class_7771(this.width, this.height), image, resourceMetadata.method_43041(class_1079.field_55537), resourceMetadata.method_72364(List.of(class_1079.field_55537))), metadata.palette());
    }

    @Nullable
    protected abstract TrimSpriteMetadata getSpriteMetadata(class_8053 var1, @Nullable class_9473 var2, class_2960 var3);

    protected abstract class_1011 createImageFromMetadata(TrimSpriteMetadata var1);

    @NotNull
    private class_7368 getResourceMetadataFromSpriteMetadata(TrimSpriteMetadata metadata) {
        if (metadata.isAnimated()) {
            return new class_7368(this){

                @NotNull
                public <T> Optional<T> method_43041(@NotNull class_7677<T> metadataSectionType) {
                    if (metadataSectionType.equals((Object)class_1079.field_55537)) {
                        return Optional.of(new class_1079(Optional.empty(), Optional.empty(), Optional.empty(), 1, false));
                    }
                    return Optional.empty();
                }
            };
        }
        return class_7368.field_38688;
    }

    protected class_1011 createColouredImage(TrimSpriteMetadata metadata, class_10539 contents) {
        TrimPalette palette = metadata.palette();
        class_1011 grey = contents.comp_3447();
        Path debug = Platform.getDebugDirectory().resolve(metadata.toDebugPath());
        if (Platform.isDev()) {
            try {
                debug.toFile().mkdirs();
                grey.method_4314(debug.resolve("greyscale.png"));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write greyscale pattern image", e);
            }
        }
        class_1011 coloured = palette.isAnimated() ? this.createColouredPatternAnimation(grey, palette) : this.createColouredPatternImage(grey, palette.getColours(), palette.isBuiltin());
        if (Platform.isDev()) {
            try {
                coloured.method_4314(debug.resolve("coloured.png"));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write coloured pattern image", e);
            }
        }
        return coloured;
    }

    protected class_1011 createColouredPatternImage(class_1011 greyscalePatternImage, List<Integer> colours, boolean builtin) {
        class_1011 coloured = new class_1011(this.width, this.height, false);
        IntList[] colourPositions = new IntList[256];
        int count = 0;
        boolean encounteredTransparent = false;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int pixel = greyscalePatternImage.method_61940(x, y);
                int alpha = pixel >> 24 & 0xFF;
                if (alpha == 0) {
                    coloured.method_61941(x, y, 0);
                    encounteredTransparent = true;
                    continue;
                }
                int shade = pixel & 0xFF;
                IntList positions = colourPositions[shade];
                if (positions == null) {
                    colourPositions[shade] = positions = new IntArrayList();
                    ++count;
                }
                positions.add(x);
                positions.add(y);
            }
        }
        if (count == 0) {
            return this.empty();
        }
        if (encounteredTransparent) {
            ++count;
        }
        int paletteIndex = Math.min(count - 1, 7);
        for (int colour = 0; colour < 256; ++colour) {
            int paletteColour;
            IntList positions = colourPositions[colour];
            if (positions == null) continue;
            if (colour == 0) {
                paletteColour = 0;
            } else {
                paletteColour = paletteIndex > 0 ? colours.get(paletteIndex) | 0xFF000000 : 0;
                --paletteIndex;
            }
            for (int i = 0; i < positions.size(); i += 2) {
                int x = positions.getInt(i);
                int y = positions.getInt(i + 1);
                coloured.method_61941(x, y, builtin ? paletteColour : this.applyGrayscaleMask(paletteColour, colour));
            }
        }
        return coloured;
    }

    protected class_1011 createColouredPatternAnimation(class_1011 image, TrimPalette palette) {
        List<List<Integer>> frames = this.getFrames(palette);
        int frameHeight = frames.size();
        int frameWidth = image.method_4307();
        int totalHeight = frameHeight * image.method_4323();
        class_1011 stitchedImage = new class_1011(frameWidth, totalHeight, false);
        for (int frameCount = 0; frameCount < frames.size(); ++frameCount) {
            List<Integer> frame = frames.get(frameCount);
            class_1011 coloured = this.createColouredPatternImage(image, frame, palette.isBuiltin());
            for (int y = 0; y < image.method_4323(); ++y) {
                for (int x = 0; x < image.method_4307(); ++x) {
                    int pixel = coloured.method_61940(x, y);
                    stitchedImage.method_61941(x, y + frameCount * image.method_4323(), pixel);
                }
            }
            coloured.close();
        }
        return stitchedImage;
    }

    @NotNull
    private List<List<Integer>> getFrames(TrimPalette palette) {
        List<Integer> list;
        if (palette instanceof AnimatedTrimPalette) {
            AnimatedTrimPalette animated = (AnimatedTrimPalette)palette;
            list = animated.getAnimationColours();
        } else {
            list = palette.getColours();
        }
        List<Integer> interpolatedColours = list;
        ArrayList<List<Integer>> frames = new ArrayList<List<Integer>>();
        for (int i = 0; i < 72; ++i) {
            ArrayList<Integer> frame = new ArrayList<Integer>();
            for (int j = 0; j < 8; ++j) {
                int index = (i + j) % interpolatedColours.size();
                int colour = interpolatedColours.get(index);
                frame.add(colour);
            }
            frames.add(frame);
        }
        return frames;
    }

    private int applyGrayscaleMask(int colorABGR, int maskABGR) {
        int brightness = maskABGR & 0xFF;
        int alpha = colorABGR >> 24 & 0xFF;
        int blue = colorABGR >> 16 & 0xFF;
        int green = colorABGR >> 8 & 0xFF;
        int red = colorABGR & 0xFF;
        if (brightness < 128) {
            red = red * brightness + 64 >> 7;
            green = green * brightness + 64 >> 7;
            blue = blue * brightness + 64 >> 7;
        }
        return alpha << 24 | blue << 16 | green << 8 | red;
    }

    public void clear() {
        textureCache.forEach((k, v) -> v.close());
        textureCache.clear();
    }

    protected class_1011 empty() {
        class_1011 image = new class_1011(this.width, this.height, false);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                image.method_61941(x, y, 0);
            }
        }
        return image;
    }
}

