/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.model.TrimModelId;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.client.texture.RuntimeTrimAtlas;
import com.bawnorton.trimica.client.texture.TrimArmourSpriteFactory;
import com.bawnorton.trimica.client.texture.TrimItemSpriteFactory;
import com.bawnorton.trimica.client.texture.TrimShieldSpriteFactory;
import com.bawnorton.trimica.item.component.AdditionalTrims;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.trim.TrimmedType;
import com.bawnorton.trimica.util.Lazy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_10186;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9473;

public final class RuntimeTrimAtlases {
    private final Map<class_8054, Map<class_10186.class_10190, Lazy<RuntimeTrimAtlas>>> equipmentAtlases = new HashMap<class_8054, Map<class_10186.class_10190, Lazy<RuntimeTrimAtlas>>>();
    private final Map<class_8054, Lazy<RuntimeTrimAtlas>> itemAtlases = new HashMap<class_8054, Lazy<RuntimeTrimAtlas>>();
    private final Map<class_8054, Lazy<RuntimeTrimAtlas>> shieldAtlases = new HashMap<class_8054, Lazy<RuntimeTrimAtlas>>();
    private final List<Consumer<RuntimeTrimAtlas>> modelAtlasModifiedListeners = new ArrayList<Consumer<RuntimeTrimAtlas>>();

    public void init(class_5455 registryAccess) {
        this.equipmentAtlases.values().forEach(Map::clear);
        this.equipmentAtlases.clear();
        this.itemAtlases.clear();
        this.shieldAtlases.clear();
        class_2378 materials = (class_2378)registryAccess.method_46759(class_7924.field_42083).orElseThrow();
        for (class_8054 material : materials) {
            for (class_10186.class_10190 layerType : class_10186.class_10190.values()) {
                this.createEquipmentAtlas(registryAccess, material, layerType);
            }
            this.createItemAtlas(registryAccess, material);
            this.createShieldAtlas(registryAccess, material);
        }
    }

    private void resetFrames() {
        for (Map<class_10186.class_10190, Lazy<RuntimeTrimAtlas>> layerBasedAtlases : this.equipmentAtlases.values()) {
            for (Lazy<RuntimeTrimAtlas> atlas : layerBasedAtlases.values()) {
                if (!atlas.isPresent()) continue;
                atlas.get().resetFrames();
            }
        }
    }

    private Lazy<RuntimeTrimAtlas> createEquipmentAtlas(class_5455 registryAccess, class_8054 material, class_10186.class_10190 layerType) {
        class_2378 materials = (class_2378)registryAccess.method_46759(class_7924.field_42083).orElseThrow();
        class_2378 patterns = (class_2378)registryAccess.method_46759(class_7924.field_42082).orElseThrow();
        String materialId = Trimica.getMaterialRegistry().getSuffix(material);
        return new Lazy<RuntimeTrimAtlas>(() -> new RuntimeTrimAtlas(Trimica.rl("%s/%s.png".formatted(materialId, layerType.method_15434())), new TrimArmourSpriteFactory(layerType), p -> new class_8053(materials.method_47983((Object)material), patterns.method_47983((Object)p)), atlas -> {
            this.resetFrames();
            for (Consumer<RuntimeTrimAtlas> listener : this.modelAtlasModifiedListeners) {
                listener.accept((RuntimeTrimAtlas)((Object)((Object)atlas)));
            }
        }));
    }

    private Lazy<RuntimeTrimAtlas> createItemAtlas(class_5455 registryAccess, class_8054 material) {
        class_2378 materials = (class_2378)registryAccess.method_46759(class_7924.field_42083).orElseThrow();
        class_2378 patterns = (class_2378)registryAccess.method_46759(class_7924.field_42082).orElseThrow();
        String materialId = Trimica.getMaterialRegistry().getSuffix(material);
        return new Lazy<RuntimeTrimAtlas>(() -> new RuntimeTrimAtlas(Trimica.rl("%s/item.png".formatted(materialId)), new TrimItemSpriteFactory(), p -> new class_8053(materials.method_47983((Object)material), patterns.method_47983((Object)p)), atlas -> {
            TrimicaClient.getItemModelFactory().clearModels();
            for (Consumer<RuntimeTrimAtlas> listener : this.modelAtlasModifiedListeners) {
                listener.accept((RuntimeTrimAtlas)((Object)((Object)atlas)));
            }
        }));
    }

    private Lazy<RuntimeTrimAtlas> createShieldAtlas(class_5455 registryAccess, class_8054 material) {
        class_2378 materials = (class_2378)registryAccess.method_46759(class_7924.field_42083).orElseThrow();
        class_2378 patterns = (class_2378)registryAccess.method_46759(class_7924.field_42082).orElseThrow();
        String materialId = Trimica.getMaterialRegistry().getSuffix(material);
        return new Lazy<RuntimeTrimAtlas>(() -> new RuntimeTrimAtlas(Trimica.rl("%s/shield.png".formatted(materialId)), new TrimShieldSpriteFactory(), p -> new class_8053(materials.method_47983((Object)material), patterns.method_47983((Object)p)), atlas -> {
            for (Consumer<RuntimeTrimAtlas> listener : this.modelAtlasModifiedListeners) {
                listener.accept((RuntimeTrimAtlas)((Object)((Object)atlas)));
            }
        }));
    }

    public RuntimeTrimAtlas getEquipmentAtlas(class_638 level, class_8054 material, class_10186.class_10190 layerType) {
        return (RuntimeTrimAtlas)((Object)this.equipmentAtlases.computeIfAbsent(material, k -> new HashMap()).computeIfAbsent(layerType, k -> this.createEquipmentAtlas(level.method_30349(), material, layerType)).get());
    }

    public RuntimeTrimAtlas getItemAtlas(class_638 level, class_8054 material) {
        return (RuntimeTrimAtlas)((Object)this.itemAtlases.computeIfAbsent(material, k -> this.createItemAtlas(level.method_30349(), (class_8054)k)).get());
    }

    public RuntimeTrimAtlas getShieldAtlas(class_638 level, class_8054 material) {
        return (RuntimeTrimAtlas)((Object)this.shieldAtlases.computeIfAbsent(material, k -> this.createShieldAtlas(level.method_30349(), (class_8054)k)).get());
    }

    public List<DynamicTrimTextureAtlasSprite> getShieldSprites(class_638 level, class_9473 getter) {
        ArrayList<DynamicTrimTextureAtlasSprite> sprites = new ArrayList<DynamicTrimTextureAtlasSprite>();
        List<class_8053> trims = AdditionalTrims.getAllTrims(getter);
        for (class_8053 trim : trims) {
            TrimModelId trimModelId = TrimModelId.fromTrim(TrimmedType.SHIELD, trim, null);
            class_2960 overlayLocation = trimModelId.asSingle();
            if (MaterialAdditions.enableMaterialAdditions) {
                MaterialAdditions addition = (MaterialAdditions)getter.method_58695(MaterialAdditions.TYPE, (Object)MaterialAdditions.NONE);
                overlayLocation = addition.apply(overlayLocation);
            }
            sprites.add(this.getShieldAtlas(level, (class_8054)trim.comp_3179().comp_349()).getSprite(getter, (class_8056)trim.comp_3180().comp_349(), overlayLocation));
        }
        return sprites;
    }

    public void addModelAtlasModifiedListener(Consumer<RuntimeTrimAtlas> listener) {
        this.modelAtlasModifiedListeners.add(listener);
    }

    public void clear() {
        this.equipmentAtlases.forEach((pattern, lazyMap) -> lazyMap.forEach((layer, lazy) -> lazy.ifPresent(RuntimeTrimAtlas::clear)));
        this.itemAtlases.forEach((pattern, lazy) -> lazy.ifPresent(RuntimeTrimAtlas::clear));
        this.shieldAtlases.forEach((pattern, lazy) -> lazy.ifPresent(RuntimeTrimAtlas::clear));
        this.equipmentAtlases.clear();
        this.itemAtlases.clear();
        this.shieldAtlases.clear();
    }

    public static interface TrimFactory {
        public class_8053 create(class_8056 var1);
    }
}

