/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.trimica.mixin.registry.tag;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.TrimicaToggles;
import com.bawnorton.trimica.trim.TrimMaterialRuntimeRegistry;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_3503;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_3503.class})
abstract class TagLoaderMixin {
    @Unique
    private static final ThreadLocal<class_2385<class_8054>> trimica$trimRegistry = new ThreadLocal();

    TagLoaderMixin() {
    }

    @WrapOperation(method={"method_61308(Lnet/minecraft/class_3300;Lnet/minecraft/class_2385;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2385;method_46765()Lnet/minecraft/class_5321;")})
    private static <T> class_5321<T> captureTrimRegistry(class_2385<T> instance, Operation<class_5321<T>> original) {
        class_5321 key = (class_5321)original.call(new Object[]{instance});
        if (key.equals(class_7924.field_42083)) {
            trimica$trimRegistry.set(instance);
        } else {
            trimica$trimRegistry.remove();
        }
        return key;
    }

    @WrapOperation(method={"method_43952(Lnet/minecraft/class_3497$class_7474;Ljava/util/List;)Lcom/mojang/datafixers/util/Either;"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false)})
    private <E, T> boolean performRuntimeTagManipulation(List<E> instance, E e, Operation<Boolean> original, @Local SequencedSet<T> set) {
        class_3503.class_5145 entryWithSource = (class_3503.class_5145)e;
        class_3497 entry = entryWithSource.comp_324();
        return TagLoaderMixin.trimica$ignoreLiteralReferencesToDisabledItems(entry) && (Boolean)original.call(new Object[]{instance, e}) != false;
    }

    @WrapOperation(method={"method_43952(Lnet/minecraft/class_3497$class_7474;Ljava/util/List;)Lcom/mojang/datafixers/util/Either;"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3497;method_26790(Lnet/minecraft/class_3497$class_7474;Ljava/util/function/Consumer;)Z")})
    private <T> boolean forwardTrimicaMaterialTagReferences(class_3497 instance, class_3497.class_7474<T> lookup, Consumer<T> consumer, Operation<Boolean> original) {
        boolean didSucceed = (Boolean)original.call(new Object[]{instance, lookup, consumer});
        if (didSucceed) {
            return true;
        }
        if (trimica$trimRegistry.get() != null) {
            return TagLoaderMixin.trimica$tryCreateRuntimeTag(instance, trimica$trimRegistry.get(), consumer);
        }
        return false;
    }

    @Unique
    private static boolean trimica$tryCreateRuntimeTag(class_3497 entry, class_2385<class_8054> registry, Consumer<class_6880.class_6883<class_8054>> consumer) {
        class_2960 materialLocation;
        String entryId = entry.toString();
        int trimicaGeneratedIndex = entryId.indexOf("trimica:generated/");
        if (trimicaGeneratedIndex == -1) {
            return false;
        }
        String materialName = entryId.substring(trimicaGeneratedIndex + "trimica:generated/".length());
        int slashIndex = materialName.indexOf(47);
        if (slashIndex == -1) {
            return false;
        }
        String materialNamespace = materialName.substring(0, slashIndex);
        String materialPath = materialName.substring(slashIndex + 1);
        if (materialPath.endsWith("?")) {
            materialPath = materialPath.substring(0, materialPath.length() - 1);
        }
        if ((materialLocation = class_2960.method_43902((String)materialNamespace, (String)materialPath)) == null) {
            return false;
        }
        Optional item = class_7923.field_41178.method_10223(materialLocation);
        if (item.isEmpty()) {
            Trimica.LOGGER.warn("Could not find item \"{}\" to create trim material tag for", (Object)materialLocation);
            return false;
        }
        class_6880.class_6883<class_8054> material = Trimica.getRuntimeTags().createMaterialTagForItem((class_6880.class_6883<class_1792>)((class_6880.class_6883)item.orElseThrow()), registry);
        if (material == null) {
            return false;
        }
        consumer.accept(material);
        return true;
    }

    @Unique
    private static boolean trimica$ignoreLiteralReferencesToDisabledItems(class_3497 entry) {
        String entryId = entry.toString();
        if (!(TrimicaToggles.enableRainbowifier && TrimicaToggles.enableItems || !entryId.equals("trimica:rainbowifier"))) {
            return false;
        }
        if (!(TrimicaToggles.enableAnimator && TrimicaToggles.enableItems || !entryId.equals("trimica:animator"))) {
            return false;
        }
        if (!TrimicaToggles.enableItems) {
            return !entryId.equals("trimica:fake_addition");
        }
        if (!TrimMaterialRuntimeRegistry.enableTrimEverything) {
            return !entryId.startsWith("#trimica:generated/");
        }
        return true;
    }
}

