package com.bawnorton.trimica;

import com.bawnorton.trimica.platform.Platform;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

import java.util.List;
import java.util.Set;

public class TrimicaMixinConfigPlugin implements IMixinConfigPlugin {
	@Override
	public void onLoad(String mixinPackage) {
	}

	@Override
	public String getRefMapperConfig() {
		return null;
	}

	@Override
	public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
		String compatIdentifier = "mixin.compat.";
		int compatIndex = mixinClassName.indexOf(compatIdentifier);
		if (compatIndex == -1) return true;

		String compatMixinName = mixinClassName.substring(compatIndex + compatIdentifier.length());
		String compatId = compatMixinName.substring(0, compatMixinName.indexOf('.'));
		return Platform.isModLoaded(compatId);
	}

	@Override
	public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
	}

	@Override
	public List<String> getMixins() {
		return null;
	}

	@Override
	public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
	}

	@Override
	public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
	}
}
