package com.bawnorton.trimica.client.texture;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.api.client.impl.TrimicaClientApiImpl;
import com.bawnorton.trimica.api.impl.TrimicaApiImpl;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.trim.TrimmedType;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import net.minecraft.class_1011;
import net.minecraft.class_10539;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9473;

public class TrimShieldSpriteFactory extends AbstractTrimSpriteFactory {
	public TrimShieldSpriteFactory() {
		super(64, 64);
	}

	@Override
	protected @Nullable TrimSpriteMetadata getSpriteMetadata(class_8053 trim, @Nullable class_9473 componentGetter, class_2960 texture) {
		class_8054 material = trim.comp_3179().comp_349();
		TrimPalette palette = TrimicaClient.getPalettes().getOrGeneratePalette(material, null, componentGetter);
		class_2960 basePatternTexture = getPatternBasedTrimOverlay(trim);
		// TrimicaApiImpl method deprecated for removal in 2.0.0
		basePatternTexture = TrimicaApiImpl.INSTANCE.applyBaseTextureInterceptorsForShield(basePatternTexture, componentGetter, trim);
		basePatternTexture = TrimicaClientApiImpl.INSTANCE.applyBaseTextureInterceptorsForShield(basePatternTexture, componentGetter, trim);
		return new TrimSpriteMetadata(trim, palette, basePatternTexture, TrimmedType.SHIELD);
	}

	@Override
	protected class_1011 createImageFromMetadata(TrimSpriteMetadata metadata) {
		class_10539 contents = textureCache.computeIfAbsent(metadata.baseTexture(), k -> {
			class_3300 resourceManager = class_310.method_1551().method_1478();
			try {
				return class_10539.method_65871(resourceManager, metadata.baseTexture());
			} catch (IOException e) {
				try {
					return class_10539.method_65871(resourceManager, getDefaultTrimOverlay());
				} catch (IOException ex) {
					ex.addSuppressed(e);
					Trimica.LOGGER.warn("Expected to find \"{}\" but the texture does of exist, trim overlay will not be added to model", metadata.baseTexture());
					return new class_10539(empty(), null);
				}
			}
		});
		return createColouredImage(metadata, contents);
	}

	private class_2960 getPatternBasedTrimOverlay(class_8053 trim) {
		class_5321<class_8056> patternKey = trim.comp_3180().method_40230().orElse(null);
		if (patternKey == null) return null;

		class_2960 location = patternKey.method_29177();
		return Trimica.rl("textures/trims/items/shield/%s/%s.png".formatted(
				location.method_12836(),
				location.method_12832()
		));
	}

	private class_2960 getDefaultTrimOverlay() {
		return Trimica.rl("textures/trims/items/shield/default.png");
	}
}