package com.bawnorton.trimica.data;

import java.util.Map;
import net.minecraft.class_10394;
import net.minecraft.class_10714;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_8054;

public final class TrimicaDataFixer {
	public class_6880<class_8054> fixDynamicTrimMaterialSuffix(class_6880<class_8054> material) {
		if (material instanceof class_6880.class_6881<class_8054>(class_8054 value)) {
			class_8054 fixedMaterial = fixDynamicTrimMaterialSuffix(value);
			return class_6880.method_40223(fixedMaterial);
		}
		return material;
	}

	private static class_8054 fixDynamicTrimMaterialSuffix(class_8054 value) {
		class_10714 assets = value.comp_3606();
		class_10714.class_10715 base = assets.comp_3603();
		Map<class_5321<class_10394>, class_10714.class_10715> overrides = assets.comp_3604();

		class_10714.class_10715 fixed = fixAssetInfo(base);
		for (Map.Entry<class_5321<class_10394>, class_10714.class_10715> entry : overrides.entrySet()) {
			class_10714.class_10715 fixedOverride = fixAssetInfo(entry.getValue());
			if (fixedOverride != entry.getValue()) {
				overrides.put(entry.getKey(), fixedOverride);
			}
		}
		if (fixed != base || !overrides.equals(assets.comp_3604())) {
			class_10714 fixedAssets = new class_10714(fixed, overrides);
			return new class_8054(fixedAssets, value.comp_1212());
		}
		return value;
	}

	private static class_10714.class_10715 fixAssetInfo(class_10714.class_10715 base) {
		String existingSuffix = base.comp_3605();
		int trimicaStartIndex = existingSuffix.indexOf("trimica/");
		if (trimicaStartIndex == -1) {
			return base;
		}
		String dynamicComponent = existingSuffix.substring(trimicaStartIndex + "trimica/".length());
		/*
		 if the dynamic component is of the pattern `namespace-path` convert it to `namespace/path`, however
		 `namespace/path-more` is valid and should not be changed, and so we only replace the first `-` with `/`
		 if it is before any `/` character
		*/
		int slashIndex = dynamicComponent.indexOf('/');
		int dashIndex = dynamicComponent.indexOf('-');
		if (dashIndex != -1 && (slashIndex == -1 || dashIndex < slashIndex)) {
			String fixedComponent = dynamicComponent.replaceFirst("-", "/");
			String fixedSuffix = "trimica/" + fixedComponent;
			return new class_10714.class_10715(fixedSuffix);
		}
		return base;
	}
}
