package com.bawnorton.trimica.mixin.component;

import com.bawnorton.trimica.item.component.ComponentUtil;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9335;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_9335.class)
public abstract class PatchedDataComponentMapMixin implements class_9323 {
	@Shadow
	@Nullable
	public abstract <T> T set(class_9331<T> dataComponentType, @Nullable T object);

	@ModifyReturnValue(
			method = "get",
			at = @At("RETURN")
	)
	private <T> T fakeComponents(T original, class_9331<? extends T> type) {
		return ComponentUtil.getFakeComponents(this, original, type);
	}

	@Inject(
			method = "set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;",
			at = @At("RETURN")
	)
	private <T> void setFakeComponents(class_9331<T> type, @Nullable T object, CallbackInfoReturnable<T> cir) {
		ComponentUtil.setFakeComponents(this::set, this, type, object);
	}
}
