package com.bawnorton.trimica.mixin.registry.tag;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.data.tags.TrimicaRuntimeTags;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.core.*;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;
import java.util.Set;

@Mixin(class_2370.class)
abstract class MappedRegistryMixin<T> implements class_2385<T> {
	@Shadow
	@Final
	private class_5321<? extends class_2378<T>> key;

	@Shadow
	@Final
	private Map<class_6862<T>, class_6885.class_6888<T>> frozenTags;

	@SuppressWarnings("unchecked")
	@Inject(
			method = "freeze",
			at = @At(
					value = "FIELD",
					target = "Lnet/minecraft/core/MappedRegistry;frozen:Z",
					opcode = Opcodes.PUTFIELD
			)
	)
	private void addRuntimeTags(CallbackInfoReturnable<class_2378<T>> cir) {
		if(key.equals(class_7924.field_42083)) {
			TrimicaRuntimeTags runtimeTags = Trimica.getRuntimeTags();
			Set<class_6885.class_6888<class_8054>> tags = runtimeTags.bindTags((class_2378<class_8054>) this);
			tags.forEach(tag -> frozenTags.put((class_6862<T>) tag.method_40251(), (class_6885.class_6888<T>) tag));
			runtimeTags.clearUnbound();
		}
	}
}