package com.bawnorton.trimica.trim;

import com.bawnorton.configurable.Configurable;
import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_10394;
import net.minecraft.class_10714;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8054;
import net.minecraft.class_9334;
import net.minecraft.class_9473;

public final class TrimMaterialRuntimeRegistry {
	public static final class_6880<class_8054> UNKNOWN_HOLDER = class_6880.method_40223(new class_8054(class_10714.method_67229("unknown"), class_2561.method_43470("unknown")));
	private final Map<class_8054, MaterialAdditions> intrinsicAdditions = new HashMap<>();
	private final Map<class_8054, class_1792> materialProviders = new HashMap<>();
	private final Map<class_2960, class_6880<class_8054>> materials = new HashMap<>();

	/**
	 * Whether you can trim anything with anything.
	 * Disabling this will prevent non-builtin materials from being used for trimming
	 * and prevent any armour that doesn't support trimming from being trimmed
	 */
	@Configurable(onSet = "com.bawnorton.trimica.Trimica#refreshEverything")
	public static boolean enableTrimEverything = true;

	public class_1792 guessMaterialProvider(class_8054 material) {
		return materialProviders.computeIfAbsent(material, k -> {
			String suffix = Trimica.getMaterialRegistry().getSuffix(material);
			int trimicaStartIndex = suffix.indexOf("trimica/");
			if (trimicaStartIndex == -1) {
				return null;
			}
			String materialId = suffix.substring(trimicaStartIndex + "trimica/".length()).replaceFirst("/", ":");
			class_2960 id = class_2960.method_12829(materialId);
			if (id == null) {
				return null;
			}
			return class_7923.field_41178.method_17966(id).orElse(null);
		});
	}

	public class_6880<class_8054> getOrCreate(class_9473 getter) {
		class_2960 itemKey = getter.method_58694(class_9334.field_54199);
		if (itemKey == null) return UNKNOWN_HOLDER;

		class_2960 materialKey = Trimica.rl("generated/%s/%s".formatted(itemKey.method_12836(), itemKey.method_12832()));
		return materials.computeIfAbsent(materialKey, k -> {
			String suffix = "trimica/%s/%s".formatted(itemKey.method_12836(), itemKey.method_12832());
			class_10714 id = class_10714.method_67229(suffix);
			return class_6880.method_40223(new class_8054(id, class_2561.method_43469("trimica.material", getter.method_58695(class_9334.field_50239, class_2561.method_43470("Unknown")))));
		});
	}

	public String getSuffix(class_8054 material, class_5321<class_10394> assetKey) {
		return assetKey == null ? material.comp_3606().comp_3603().comp_3605() : material.comp_3606().method_67227(assetKey).comp_3605();
	}

	public String getSuffix(class_8054 material) {
		return material.comp_3606().comp_3603().comp_3605();
	}

	public void registerMaterialReference(class_6880.class_6883<class_8054> reference) {
		materials.put(reference.method_40237().method_29177(), reference);
	}

	public void setIntrinsicAdditions(class_8054 material, MaterialAdditions addition) {
		if (addition == null) return;

		intrinsicAdditions.put(material, addition);
	}

	public MaterialAdditions getIntrinsicAdditions(class_8054 trimMaterial) {
		return intrinsicAdditions.getOrDefault(trimMaterial, MaterialAdditions.NONE);
	}

	public void clear() {
		materialProviders.clear();
		materials.clear();
	}
}