//? if fabric {
package com.bawnorton.trimica.platform.fabric.test;

import com.bawnorton.trimica.Trimica;
import com.bawnorton.trimica.item.TrimicaItems;
import com.bawnorton.trimica.item.component.ComponentUtil;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import dev.kikugie.fletching_table.annotation.fabric.Entrypoint;
import net.fabricmc.fabric.api.client.gametest.v1.FabricClientGameTest;
import net.fabricmc.fabric.api.client.gametest.v1.context.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.context.TestServerContext;
import net.fabricmc.fabric.api.client.gametest.v1.context.TestSingleplayerContext;
import net.fabricmc.fabric.api.client.gametest.v1.screenshot.TestScreenshotComparisonAlgorithm;
import net.fabricmc.fabric.api.client.gametest.v1.screenshot.TestScreenshotComparisonOptions;
import net.minecraft.class_10192;
import net.minecraft.class_10394;
import net.minecraft.class_10711;
import net.minecraft.class_10714;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_4862;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8055;
import net.minecraft.class_8056;
import net.minecraft.class_8057;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@SuppressWarnings("UnstableApiUsage")
@Entrypoint("fabric-client-gametest")
public class TrimicaTests implements FabricClientGameTest {
    private final AtomicReference<class_3222> playerRef = new AtomicReference<>();

    public void runTest(ClientGameTestContext context) {
        context.getInput().resizeWindow(1024, 512);
        context.runOnClient(client -> {
            client.field_1690.method_42503().method_41748(2);
            client.field_1690.method_42510().method_41748(5);
        });

        try(TestSingleplayerContext singleplayerContext = context.worldBuilder().create()) {
            TestServerContext serverContext = singleplayerContext.getServer();
            setupPlayer(serverContext, singleplayerContext);
            // validate builtin vanilla trim
            applyTrimAndValidate(context, serverContext, class_1802.field_43198, class_1802.field_8743, class_1802.field_8477, getValidatorFor(
                    "diamond",
                    class_2960.method_60656("silence")
            ));
            // validate builtin shield trim
            applyTrimAndValidate(context, serverContext, class_1802.field_49817, class_1802.field_8255, class_1802.field_8725, getValidatorFor(
                    "redstone",
                    class_2960.method_60656("flow")
            ));
            // validate custom vanilla trim
            applyTrimAndValidate(context, serverContext, class_1802.field_49818, class_1802.field_8058, class_1802.field_8301, getValidatorFor(
                    "trimica/%s".formatted(class_7923.field_41178.method_10221(class_1802.field_8301).toString().replace(":", "/")),
                    class_2960.method_60656("bolt")
            ));
            // validate custom shield trim
            applyTrimAndValidate(context, serverContext, class_1802.field_41951, class_1802.field_8255, class_1802.field_8449, getValidatorFor(
                    "trimica/%s".formatted(class_7923.field_41178.method_10221(class_1802.field_8449).toString().replace(":", "/")),
                    class_2960.method_60656("ward")
            ));
            // validate rainbow trim
            applyTrimAndValidate(context, serverContext, class_1802.field_41952, class_1802.field_8090, TrimicaItems.RAINBOWIFIER, getValidatorFor(
                    "rainbow",
                    class_2960.method_60656("eye")
            ));

            // validate material addition
            applyTrimMaterialAdditionAndValidate(context, serverContext, class_1802.field_41949, class_1802.field_8678, class_1802.field_27070, TrimicaItems.ANIMATOR, addition -> {
                class_2960 expectedKey = class_7923.field_41178.method_10221(TrimicaItems.ANIMATOR);
                if (!addition.matches(expectedKey)) {
                    throw new AssertionError("Expected material addition %s to be present, found %s".formatted(expectedKey, addition.additionKeys()));
                }
            });

            // validate material addition
            applyTrimMaterialAdditionAndValidate(context, serverContext, class_1802.field_41956, class_1802.field_8570, class_1802.field_8449, class_1802.field_28410, addition -> {
                class_2960 expectedKey = class_7923.field_41178.method_10221(class_1802.field_28410);
                if (!addition.matches(expectedKey)) {
                    throw new AssertionError("Expected material addition %s to be present, found %s".formatted(expectedKey, addition.additionKeys()));
                }
            });

            context.runOnClient(client -> {
                client.field_1690.field_1842 = true;
                client.field_1690.method_41808().method_41748(70);
            });

            class_6880<class_8056> silencePattern = serverContext.computeOnServer(server -> {
                class_2378<class_8056> trimPatterns = server.method_30611().method_46759(class_7924.field_42082).orElseThrow();
                return trimPatterns.method_46747(class_8057.field_43223);
            });

            class_6880<class_8054> goldMaterial = serverContext.computeOnServer(server -> {
                class_2378<class_8054> trimMaterials = server.method_30611().method_46759(class_7924.field_42083).orElseThrow();
                return trimMaterials.method_46747(class_8055.field_42009);
            });

            // validate rendering of builtin trim
            createTrimmedArmourStand(context, serverContext, goldMaterial, silencePattern, () -> context.assertScreenshotEquals(TestScreenshotComparisonOptions.of("gold_silence_armour_stand").withAlgorithm(TestScreenshotComparisonAlgorithm.meanSquaredDifference(0.001f))));

            class_6880<class_8054> enderPearlMaterial = serverContext.computeOnServer(server -> {
                class_1799 enderPearl = class_1802.field_8634.method_7854();
                class_10711 trimMaterialProvider = enderPearl.method_58694(class_9334.field_56397);
                if (trimMaterialProvider == null) {
                    throw new AssertionError("Expected trim material provider, got null");
                }
                return trimMaterialProvider.comp_3599().comp_3636().left().orElseThrow();
            });

            // validate rendering of custom trim
            createTrimmedArmourStand(context, serverContext, enderPearlMaterial, silencePattern, () -> context.assertScreenshotEquals(TestScreenshotComparisonOptions.of("ender_pearl_silence_armour_stand").withAlgorithm(TestScreenshotComparisonAlgorithm.meanSquaredDifference(0.001f))));
        }

        Trimica.LOGGER.info("Trimica Tests Passed");
    }

    private void createTrimmedArmourStand(
            ClientGameTestContext context,
            TestServerContext serverContext,
            class_6880<class_8054> material,
            class_6880<class_8056> pattern,
            Runnable validator) {
        class_1531 spawned = serverContext.computeOnServer(server -> {
            class_8053 trim = new class_8053(material, pattern);
            List<class_1799> toEquip = ComponentUtil.getTrimmedEquipment(trim);
            class_2338 pos = new class_2338(0, -60, 4);
            class_3218 level = server.method_30002();
            class_1531 stand = class_1299.field_6131.method_5888(
                    level, armourStand -> {
                        armourStand.method_5875(true);
                        armourStand.method_6907(true);
                        armourStand.method_6913(true);
                        toEquip.forEach(stack -> {
                            class_10192 equippable = stack.method_58694(class_9334.field_54196);
                            assert equippable != null;

                            armourStand.method_5673(equippable.comp_3174(), stack);
                        });
                    }, pos, class_3730.field_16471, false, false);
            if (stand != null) {
                stand.method_5702(class_2183.class_2184.field_9853, new class_243(3.5, -60, 0.5));
                level.method_8649(stand);
            }
            return stand;
        });
        context.waitTick();
        validator.run();
        serverContext.runOnServer(server -> spawned.method_5768(server.method_30002()));
        context.waitTick();
    }

    private void setupPlayer(TestServerContext serverContext, TestSingleplayerContext singleplayerContext) {
        serverContext.runCommand("/tp @a 0 -60 0");
        serverContext.runOnServer(server -> {
            class_3222 player = server.method_3760().method_14571().getFirst();
            playerRef.set(player);
        });
        singleplayerContext.getClientWorld().waitForChunksRender();
    }
    private void applyTrimAndValidate(
            ClientGameTestContext context,
            TestServerContext serverContext,
            class_1792 template,
            class_1792 trimmable,
            class_1792 addition,
            BiConsumer<String, class_2960> validator) {
        applyTrimAndValidate(context, serverContext, template, trimmable, addition, true, validator);
    }

    private void applyTrimAndValidate(
            ClientGameTestContext context,
            TestServerContext serverContext,
            class_1792 template,
            class_1792 trimmable,
            class_1792 addition,
            boolean clear,
            BiConsumer<String, class_2960> validator) {
        placeAndOpenSmithingTable(context, serverContext);
        serverContext.runOnServer(server -> {
            class_3222 player = playerRef.get();
            player.method_7270(template.method_7854());
            player.method_7270(trimmable.method_7854());
            player.method_7270(addition.method_7854());
            class_1703 menu = player.field_7512;
            if(!(menu instanceof class_4862 smithingMenu)) {
                throw new AssertionError("Expected SmithingMenu, got " + menu);
            }
            smithingMenu.method_7601(player, 31); // Template
            smithingMenu.method_7601(player, 32); // Trimmable
            smithingMenu.method_7601(player, 33); // Addition
            smithingMenu.method_7601(player, 3);  // Smithing Menu Output

            player.method_7346();
        });
        context.waitTick(); // ensure the menu is closed
        serverContext.runOnServer(server -> {
            class_3222 player = playerRef.get();
            class_1723 inventoryMenu = player.field_7498;
            class_1799 result = inventoryMenu.method_7611(44).method_7677(); // Rightmost slot in the hotbar
            class_8053 trim = result.method_58694(class_9334.field_49607);
            if(trim == null) {
                throw new AssertionError("Expected trim, got null");
            }
            class_10192 equippable = trimmable.method_57347().method_58694(class_9334.field_54196);
            if(equippable == null) {
                throw new AssertionError("Expected trimmable to be equippable");
            }
            class_5321<class_10394> assetResourceKey = equippable.comp_3176().orElse(null);
            class_10714 materialAssetGroup = trim.comp_3179().comp_349().comp_3606();
            String suffix = assetResourceKey == null ? materialAssetGroup.comp_3603().comp_3605() : materialAssetGroup.method_67227(assetResourceKey).comp_3605();
            class_2960 patternKey = trim.comp_3180().comp_349().comp_1213();

            validator.accept(suffix, patternKey);
            if (clear) {
                player.method_31548().method_5448();
            }
        });
    }

    private void placeAndOpenSmithingTable(ClientGameTestContext context, TestServerContext serverContext) {
        serverContext.runOnServer(server -> {
            class_2338 tablePos = new class_2338(0, -60, 1);
            class_3218 level = server.method_30002();
            level.method_8652(tablePos, class_2246.field_16329.method_9564(), 0);
            class_3222 player = playerRef.get();
            player.method_17355(class_2246.field_16329.method_9564().method_26196(level, tablePos));
        });
        context.waitTick();
    }

    private @NotNull BiConsumer<String, class_2960> getValidatorFor(String expectedSuffix, class_2960 expectedPattern) {
        return (material, pattern) -> {
            if (!material.equals(expectedSuffix)) {
                throw new AssertionError("Expected material %s, got %s".formatted(expectedSuffix, material));
            }
            if (!pattern.equals(expectedPattern)) {
                throw new AssertionError("Expected pattern %s, got %s".formatted(expectedPattern, pattern));
            }
        };
    }

    private void applyTrimMaterialAdditionAndValidate(
            ClientGameTestContext context,
            TestServerContext serverContext,
            class_1792 template,
            class_1792 trimmable,
            class_1792 addition,
            class_1792 materialAddition,
            Consumer<MaterialAdditions> validator) {
        applyTrimAndValidate(context, serverContext, template, trimmable, addition, false, (material, pattern) -> {});
        placeAndOpenSmithingTable(context, serverContext);
        serverContext.runOnServer(server -> {
            class_3222 player = playerRef.get();
            player.method_7270(materialAddition.method_7854());
            class_1703 menu = player.field_7512;
            if(!(menu instanceof class_4862 smithingMenu)) {
                throw new AssertionError("Expected SmithingMenu, got " + menu);
            }
            smithingMenu.method_7601(player, 39); // Result
            smithingMenu.method_7601(player, 31); // Addition
            smithingMenu.method_7601(player, 3);  // Smithing Menu Output

            player.method_7346();
        });
        context.waitTick();
        serverContext.runOnServer(server -> {
            class_3222 player = playerRef.get();
            class_1723 inventoryMenu = player.field_7498;
            class_1799 result = inventoryMenu.method_7611(44).method_7677(); // Rightmost slot in the hotbar
            MaterialAdditions materialAdditionsComponent = result.method_58694(MaterialAdditions.TYPE);
            if (materialAdditionsComponent == null) {
                throw new AssertionError("Expected material addition, got null");
            }
            validator.accept(materialAdditionsComponent);
        });
    }
}
//?}