package com.bawnorton.trimica.api.client.impl;

import com.bawnorton.trimica.api.BaseTextureInterceptor;
import com.bawnorton.trimica.api.PaletteInterceptor;
import com.bawnorton.trimica.api.client.TrimicaClientApi;
import com.bawnorton.trimica.api.client.TrimicaRenderer;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.item.component.MaterialAdditions;
import com.bawnorton.trimica.util.SortableEndpointHolder;
import org.jetbrains.annotations.ApiStatus;

import java.util.PriorityQueue;
import java.util.Queue;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_9473;

@ApiStatus.Internal
public final class TrimicaClientApiImpl implements TrimicaClientApi {
	public static final TrimicaClientApiImpl INSTANCE = new TrimicaClientApiImpl();

	private final TrimicaRenderer renderer = new TrimicaRendererImpl();

	private final Queue<SortableEndpointHolder<BaseTextureInterceptor>> baseTextureInterceptors = new PriorityQueue<>();
	private final Queue<SortableEndpointHolder<PaletteInterceptor>> paletteInterceptors = new PriorityQueue<>();

	public TrimicaRenderer getRenderer() {
		return renderer;
	}

	public void registerBaseTextureInterceptor(int priority, BaseTextureInterceptor baseTextureInterceptor) {
		baseTextureInterceptors.add(new SortableEndpointHolder<>(baseTextureInterceptor, priority));
	}

	public void registerPaletteInterceptor(int priority, PaletteInterceptor paletteInterceptor) {
		paletteInterceptors.add(new SortableEndpointHolder<>(paletteInterceptor, priority));
	}

	public class_2960 applyBaseTextureInterceptorsForItem(class_2960 expectedBaseTexture, class_1799 itemWithTrim, class_8053 armourTrim) {
		for (SortableEndpointHolder<BaseTextureInterceptor> endpointHolder : baseTextureInterceptors) {
			expectedBaseTexture = endpointHolder.endpoint().interceptItemTexture(expectedBaseTexture, itemWithTrim, armourTrim);
		}
		return expectedBaseTexture;
	}

	public class_2960 applyBaseTextureInterceptorsForArmour(class_2960 expectedBaseTexture, class_1799 itemWithTrim, class_8053 armourTrim) {
		for (SortableEndpointHolder<BaseTextureInterceptor> endpointHolder : baseTextureInterceptors) {
			expectedBaseTexture = endpointHolder.endpoint().interceptArmourTexture(expectedBaseTexture, itemWithTrim, armourTrim);
		}
		return expectedBaseTexture;
	}

	public class_2960 applyBaseTextureInterceptorsForShield(class_2960 expectedBaseTexture, class_9473 componentGetter, class_8053 armourTrim) {
		for (SortableEndpointHolder<BaseTextureInterceptor> endpointHolder : baseTextureInterceptors) {
			expectedBaseTexture = endpointHolder.endpoint().interceptShieldTexture(expectedBaseTexture, componentGetter, armourTrim);
		}
		return expectedBaseTexture;
	}

	public TrimPalette applyPaletteInterceptorsForGeneration(TrimPalette generated, class_8054 material, MaterialAdditions materialAdditions) {
		for (SortableEndpointHolder<PaletteInterceptor> endpointHolder : paletteInterceptors) {
			generated = endpointHolder.endpoint().interceptPaletteGeneration(generated, material, materialAdditions);
		}
		return generated;
	}
}
