package com.bawnorton.trimica.api.client.impl;

import com.bawnorton.trimica.api.client.TrimicaRenderer;
import com.bawnorton.trimica.client.TrimicaClient;
import com.bawnorton.trimica.client.palette.TrimPalette;
import com.bawnorton.trimica.client.texture.DynamicTrimTextureAtlasSprite;
import com.bawnorton.trimica.compat.Compat;
import java.util.List;
import net.minecraft.class_10209;
import net.minecraft.class_11659;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import net.minecraft.class_765;
import net.minecraft.class_9323;

public final class TrimicaRendererImpl implements TrimicaRenderer {
	//? if >=1.21.10 {
	public void submitShieldTrim(class_630 plate, class_9323 components, class_4587 poseStack, class_11659 nodeCollector, int packedLight, int packedOverlay, boolean hasFoil, int outlineColor) {
		class_3695 profiler = class_10209.method_64146();
		profiler.method_15396("trimica:shield");
		List<DynamicTrimTextureAtlasSprite> dynamicSprites = TrimicaClient.getRuntimeAtlases().getShieldSprites(class_310.method_1551().field_1687, components);
		for (DynamicTrimTextureAtlasSprite dynamicSprite : dynamicSprites) {
			TrimPalette palette = dynamicSprite.getPalette();
			int light = palette == null ? packedLight : (palette.isEmissive() ? class_765.field_32767 : packedLight);
			if (palette != null && palette.isAnimated()) {
				Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(dynamicSprite));
			}
			nodeCollector.method_73494(
					plate,
					poseStack,
					dynamicSprite.getRenderType(),
					light,
					packedOverlay,
					dynamicSprite,
					false,
					hasFoil,
					-1,
					null,
					outlineColor
			);
		}
		profiler.method_15407();
	}
	//?} else {
	/*public void renderShieldTrim(ModelPart plate, DataComponentMap dataComponentMap, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, boolean hasFoil) {
		ProfilerFiller profiler = Profiler.get();
		profiler.push("trimica:shield");
		List<DynamicTrimTextureAtlasSprite> dynamicSprites = TrimicaClient.getRuntimeAtlases().getShieldSprites(Minecraft.getInstance().level, dataComponentMap);
		for (DynamicTrimTextureAtlasSprite dynamicSprite : dynamicSprites) {
			TrimPalette palette = dynamicSprite.getPalette();
			int light = palette == null ? packedLight : (palette.isEmissive() ? LightTexture.FULL_BRIGHT : packedLight);
			if (palette != null && palette.isAnimated()) {
				Compat.ifSodiumPresent(compat -> compat.markSpriteAsActive(dynamicSprite));
			}
			VertexConsumer vertexConsumer = dynamicSprite.wrap(ItemRenderer.getFoilBuffer(multiBufferSource, dynamicSprite.getRenderType(), itemDisplayContext == ItemDisplayContext.GUI, hasFoil));
			plate.render(poseStack, vertexConsumer, light, packedOverlay);
		}

		profiler.pop();
	}
	*///?}
}
